

<?php $__env->startSection('title', 'API Targets'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item active">API Targets</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">
            <i class="fas fa-paper-plane me-2"></i>API Targets
        </h1>
        <a href="<?php echo e(route('api-targets.create')); ?>" class="btn btn-primary">
            <i class="fas fa-plus me-2"></i>Add New Target
        </a>
    </div>

    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                Total Targets
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                <?php echo e($api_targets->total()); ?>

                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-paper-plane fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                Active Targets
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                <?php echo e($api_targets->where('is_active', true)->count()); ?>

                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-check-circle fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                Manual Targets
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                <?php echo e($api_targets->where('schedule_type', 'manual')->count()); ?>

                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-hand-point-up fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                Scheduled Targets
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                <?php echo e($api_targets->where('schedule_type', '!=', 'manual')->count()); ?>

                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-clock fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- DataTales Example -->
    <div class="card shadow mb-4">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 font-weight-bold text-primary">
                <i class="fas fa-list me-2"></i>API Targets List
            </h6>
            <div class="dropdown no-arrow">
                <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink"
                    data-bs-toggle="dropdown" aria-expanded="false">
                    <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-400"></i>
                </a>
                <div class="dropdown-menu dropdown-menu-end shadow"
                    aria-labelledby="dropdownMenuLink">
                    <div class="dropdown-header">Actions:</div>
                    <a class="dropdown-item" href="<?php echo e(route('api-targets.create')); ?>">
                        <i class="fas fa-plus fa-sm fa-fw mr-2 text-gray-400"></i>
                        Add New Target
                    </a>
                    <div class="dropdown-divider"></div>
                    <a class="dropdown-item" href="#" onclick="refreshPage()">
                        <i class="fas fa-sync fa-sm fa-fw mr-2 text-gray-400"></i>
                        Refresh
                    </a>
                </div>
            </div>
        </div>
        <div class="card-body">
            <?php if($api_targets->count() > 0): ?>
                <div class="table-responsive">
                    <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                        <thead>
                            <tr>
                                <th>Name</th>
                                <th>URL</th>
                                <th>Method</th>
                                <th>Source Table</th>
                                <th>Status</th>
                                <th>Schedule</th>
                                <th>Last Sent</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $api_targets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $target): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="me-3">
                                                <div class="icon-circle bg-<?php echo e($target->is_active ? 'success' : 'secondary'); ?>">
                                                    <i class="fas fa-paper-plane text-dark"></i>
                                                </div>
                                            </div>
                                            <div>
                                                <div class="font-weight-bold"><?php echo e($target->name); ?></div>
                                                <?php if($target->description): ?>
                                                    <div class="small text-gray-500"><?php echo e(Str::limit($target->description, 50)); ?></div>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="font-weight-bold"><?php echo e($target->base_url); ?></div>
                                        <div class="small text-gray-500"><?php echo e($target->endpoint); ?></div>
                                    </td>
                                    <td>
                                        <span class="badge bg-<?php echo e($target->method == 'GET' ? 'success' : ($target->method == 'POST' ? 'primary' : 'warning')); ?>">
                                            <?php echo e($target->method); ?>

                                        </span>
                                    </td>
                                    <td>
                                        <code class="bg-light p-1 rounded"><?php echo e($target->source_table); ?></code>
                                    </td>
                                    <td>
                                        <span class="badge bg-<?php echo e($target->is_active ? 'success' : 'secondary'); ?>">
                                            <?php echo e($target->is_active ? 'Active' : 'Inactive'); ?>

                                        </span>
                                    </td>
                                    <td>
                                        <span class="badge bg-info"><?php echo e(ucfirst($target->schedule_type)); ?></span>
                                        <?php if($target->schedule_frequency && $target->schedule_type !== 'manual'): ?>
                                            <div class="small text-muted">Every <?php echo e($target->schedule_frequency); ?> <?php echo e($target->schedule_type == 'hourly' ? 'hour(s)' : ($target->schedule_type == 'daily' ? 'day(s)' : 'week(s)')); ?></div>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($target->last_sent_at): ?>
                                            <div class="font-weight-bold"><?php echo e($target->last_sent_at->format('d M Y')); ?></div>
                                            <div class="small text-gray-500"><?php echo e($target->last_sent_at->format('H:i:s')); ?></div>
                                        <?php else: ?>
                                            <span class="text-muted">Never</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <a href="<?php echo e(route('api-targets.show', $target)); ?>" class="btn btn-sm btn-info" title="View Details">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="<?php echo e(route('api-targets.documentation', $target)); ?>" class="btn btn-sm btn-secondary" title="Documentation">
                                                <i class="fas fa-book"></i>
                                            </a>
                                            <a href="<?php echo e(route('api-targets.edit', $target)); ?>" class="btn btn-sm btn-primary" title="Edit">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <button type="button" class="btn btn-sm btn-success" onclick="sendData(<?php echo e($target->id); ?>, '<?php echo e(addslashes($target->name)); ?>')" title="Send Data">
                                                <i class="fas fa-paper-plane"></i>
                                            </button>
                                            <button type="button" class="btn btn-sm btn-danger" title="Delete" onclick="deleteTarget(<?php echo e($target->id); ?>, '<?php echo e(addslashes($target->name)); ?>')">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <div class="d-flex justify-content-between align-items-center mt-3">
                    <div class="text-muted">
                        Showing <?php echo e($api_targets->firstItem()); ?> to <?php echo e($api_targets->lastItem()); ?> of <?php echo e($api_targets->total()); ?> results
                    </div>
                    <?php echo e($api_targets->links()); ?>

                </div>
            <?php else: ?>
                <div class="text-center py-5">
                    <i class="fas fa-paper-plane fa-3x text-gray-300 mb-3"></i>
                    <h4 class="text-gray-500">No API Targets Found</h4>
                    <p class="text-gray-400 mb-4">Start by creating your first API target to send data to external APIs.</p>
                    <a href="<?php echo e(route('api-targets.create')); ?>" class="btn btn-primary">
                        <i class="fas fa-plus me-2"></i>Create Your First API Target
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>



<!-- Send Data Modal -->
<div class="modal fade" id="sendModal" tabindex="-1" aria-labelledby="sendModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="sendModalLabel">Send Data</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p>Send data from the source table to "<span id="sendTargetName"></span>"?</p>
                <div class="alert alert-info">
                    <i class="fas fa-info-circle me-2"></i>
                    This will send the latest data from the configured source table to the target API endpoint.
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <form id="sendForm" method="POST" style="display: inline;">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="btn btn-success">
                        <i class="fas fa-paper-plane me-2"></i>Send Data
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
console.log('🚀 API Targets page scripts loading...');

// Check if dependencies are available
if (typeof jQuery === 'undefined') {
    console.error('❌ jQuery is not loaded!');
}

if (typeof bootstrap === 'undefined') {
    console.error('❌ Bootstrap is not loaded!');
}

// Wait for DOM and dependencies to be ready
document.addEventListener('DOMContentLoaded', function() {
    console.log('✅ DOM Content Loaded');
    
    // Define functions in global scope
    window.sendData = function(id, name) {
        console.log('📤 sendData called with:', id, name);
        try {
            document.getElementById('sendTargetName').textContent = name;
            document.getElementById('sendForm').action = '/api-targets/' + id + '/send';
            var sendModal = new bootstrap.Modal(document.getElementById('sendModal'));
            sendModal.show();
            console.log('✅ Send modal opened successfully');
        } catch (error) {
            console.error('❌ Error in sendData:', error);
            alert('Error opening send modal: ' + error.message);
        }
    };

    window.refreshPage = function() {
        console.log('🔄 Refreshing page...');
        location.reload();
    };

    window.deleteTarget = function(id, name) {
        if (!confirm('Are you sure you want to delete "' + name + '"? This action cannot be undone.')) {
            return;
        }

        const button = event.target.closest('button');
        const originalContent = button.innerHTML;
        button.disabled = true;
        button.innerHTML = '<i class="fas fa-spinner fa-spin"></i>';

        fetch('/api-targets/' + id, {
            method: 'DELETE',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                'Accept': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert('API Target deleted successfully');
                location.reload();
            } else {
                throw new Error(data.message || 'Unknown error');
            }
        })
        .catch(error => {
            alert('Error deleting API Target: ' + error.message);
            button.disabled = false;
            button.innerHTML = originalContent;
        });
    };

    console.log('✅ All functions defined successfully');

    // Auto-refresh every 30 seconds
    setInterval(function() {
        // Only refresh if no modals are open
        if (!document.querySelector('.modal.show')) {
            location.reload();
        }
    }, 30000);
    
    console.log('✅ Auto-refresh timer set');
});
</script>
<?php $__env->stopPush(); ?>

<style>
/* Button Text Colors */
.btn-success {
    color: #2b4a34 !important;
    background-color: #9de3bf;
    border-color: #9de3bf;
}

.btn-primary {
    color: #1a365d !important;
    background-color: #9ec5fe;
    border-color: #9ec5fe;
}

.btn-info {
    color: #1e4e8c !important;
    background-color: #a5d7f7;
    border-color: #a5d7f7;
}

.btn-warning {
    color: #603b00 !important;
    background-color: #ffd699;
    border-color: #ffd699;
}

.btn-secondary {
    color: #383d41 !important;
    background-color: #e2e6ea;
    border-color: #e2e6ea;
}

/* Hover States */
.btn-success:hover {
    color: #2b4a34 !important;
    background-color: #8ed1af;
    border-color: #8ed1af;
}

.btn-primary:hover {
    color: #1a365d !important;
    background-color: #8eb5ee;
    border-color: #8eb5ee;
}

.btn-info:hover {
    color: #1e4e8c !important;
    background-color: #95c7e7;
    border-color: #95c7e7;
}

.btn-warning:hover {
    color: #603b00 !important;
    background-color: #efc689;
    border-color: #efc689;
}

.btn-secondary:hover {
    color: #383d41 !important;
    background-color: #d2d6da;
    border-color: #d2d6da;
}

/* Badge Colors */
.badge.bg-success {
    color: #2b4a34 !important;
    background-color: #9de3bf !important;
}

.badge.bg-primary {
    color: #1a365d !important;
    background-color: #9ec5fe !important;
}

.badge.bg-info {
    color: #1e4e8c !important;
    background-color: #a5d7f7 !important;
}

.badge.bg-warning {
    color: #603b00 !important;
    background-color: #ffd699 !important;
}

.badge.bg-secondary {
    color: #383d41 !important;
    background-color: #e2e6ea !important;
}

/* Text Colors */
.text-success {
    color: #2b4a34 !important;
}

.text-primary {
    color: #1a365d !important;
}

.text-info {
    color: #1e4e8c !important;
}

.text-warning {
    color: #603b00 !important;
}

.text-secondary {
    color: #383d41 !important;
}

.text-gray-300 {
    color: #dddfeb !important;
}

.text-gray-400 {
    color: #858796 !important;
}

.text-gray-500 {
    color: #6c757d !important;
}

.text-gray-800 {
    color: #5a5c69 !important;
}

/* Icon Circle */
.icon-circle {
    height: 2.5rem;
    width: 2.5rem;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
}

.icon-circle i {
    color: #2b4a34 !important;
}

/* Card Styles */
.card {
    border: none;
    box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15);
    transition: transform 0.2s ease-in-out;
}

.card:hover {
    transform: translateY(-2px);
}

.card-header {
    background-color: #f8f9fc;
    border-bottom: 1px solid #e3e6f0;
}

/* Table Styles */
.table td {
    vertical-align: middle;
    padding: 1rem 0.75rem;
}

.table th {
    font-weight: 600;
    text-transform: uppercase;
    font-size: 0.75rem;
    color: #5a5c69;
    padding: 1rem 0.75rem;
}

/* Form Styles */
.form-control {
    border-radius: 0.35rem;
    font-size: 0.85rem;
    border-color: #d1d3e2;
}

.form-control:focus {
    border-color: #bac8f3;
    box-shadow: 0 0 0 0.2rem rgba(78, 115, 223, 0.25);
}
</style> 
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/copg1493/public_html/copilotproduction.site/resources/views/api-targets/index.blade.php ENDPATH**/ ?>