<?php

// Simple test script for POST-Only Receiver API
require_once 'vendor/autoload.php';

use Illuminate\Database\Capsule\Manager as Capsule;

// Set up database connection
$capsule = new Capsule;
$capsule->addConnection([
    'driver' => 'mysql',
    'host' => '127.0.0.1',
    'database' => 'copg1493_api',
    'username' => 'copg1493_api',
    'password' => 'P7H_s;Aco25Vv??J',
    'charset' => 'utf8mb4',
    'collation' => 'utf8mb4_unicode_ci',
    'prefix' => '',
]);

$capsule->setAsGlobal();
$capsule->bootEloquent();

echo "=== POST-Only Receiver API Test ===\n";

// Check if table exists
try {
    $tableExists = Capsule::schema()->hasTable('post_only_receivers');
    echo "Table exists: " . ($tableExists ? 'Yes' : 'No') . "\n";
    
    if ($tableExists) {
        // Count receivers
        $count = Capsule::table('post_only_receivers')->count();
        echo "Total receivers: {$count}\n";
        
        // List receivers
        $receivers = Capsule::table('post_only_receivers')
            ->select('id', 'name', 'endpoint', 'is_active')
            ->get();
            
        foreach ($receivers as $receiver) {
            $status = $receiver->is_active ? 'Active' : 'Inactive';
            echo "- ID: {$receiver->id}, Name: {$receiver->name}, Endpoint: {$receiver->endpoint}, Status: {$status}\n";
        }
        
        // Check for sample-webhook endpoint
        $sampleReceiver = Capsule::table('post_only_receivers')
            ->where('endpoint', 'sample-webhook')
            ->where('is_active', 1)
            ->first();
            
        if (!$sampleReceiver) {
            echo "\nCreating sample-webhook receiver...\n";
            
            $id = Capsule::table('post_only_receivers')->insertGetId([
                'name' => 'Sample Webhook Receiver',
                'endpoint' => 'sample-webhook',
                'target_table' => 'sample_webhook_data',
                'description' => 'Auto-created sample receiver for testing',
                'require_token' => 0,
                'is_active' => 1,
                'auto_create_table' => 1,
                'rate_limit' => 1000,
                'total_received' => 0,
                'total_success' => 0,
                'total_failed' => 0,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ]);
            
            echo "Created receiver with ID: {$id}\n";
        } else {
            echo "Sample webhook receiver already exists\n";
        }
    }
} catch (Exception $e) {
    echo "Database error: " . $e->getMessage() . "\n";
}

// Test API endpoint
echo "\n=== Testing API Endpoint ===\n";

$endpoint = 'sample-webhook';
$url = "https://copilotproduction.site/api/post/{$endpoint}";

$data = [
    'test_field' => 'test_value',
    'timestamp' => date('Y-m-d H:i:s'),
    'source' => 'test_script'
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json',
    'Accept: application/json'
]);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$contentType = curl_getinfo($ch, CURLINFO_CONTENT_TYPE);
$error = curl_error($ch);
curl_close($ch);

echo "URL: {$url}\n";
echo "HTTP Code: {$httpCode}\n";
echo "Content Type: {$contentType}\n";

if ($error) {
    echo "cURL Error: {$error}\n";
}

echo "Response Length: " . strlen($response) . " characters\n";
echo "Response:\n";
echo $response . "\n";

// Analyze response
if (empty($response)) {
    echo "❌ Empty response\n";
} elseif (json_decode($response) !== null) {
    echo "✅ Valid JSON response\n";
    $jsonData = json_decode($response, true);
    print_r($jsonData);
} else {
    echo "❌ Invalid JSON response\n";
    
    if (strpos($response, '<!DOCTYPE') !== false || strpos($response, '<html') !== false) {
        echo "Response appears to be HTML\n";
        
        // Extract error information
        if (preg_match('/<title>(.*?)<\/title>/i', $response, $matches)) {
            echo "Page Title: " . trim($matches[1]) . "\n";
        }
        
        if (preg_match('/<h1[^>]*>(.*?)<\/h1>/i', $response, $matches)) {
            echo "Main Heading: " . trim(strip_tags($matches[1])) . "\n";
        }
        
        // Look for Laravel error messages
        if (preg_match('/class="exception-message"[^>]*>(.*?)<\/div>/i', $response, $matches)) {
            echo "Laravel Error: " . trim(strip_tags($matches[1])) . "\n";
        }
    }
}

echo "\n=== Test Complete ===\n"; 