<?php

require_once 'vendor/autoload.php';

// Bootstrap Laravel
$app = require_once 'bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

try {
    // Test creating an ApiLog record
    $apiLog = App\Models\ApiLog::create([
        'api_source_id' => 1,
        'endpoint' => 'https://jsonplaceholder.typicode.com/users',
        'method' => 'GET',
        'status_code' => 200,
        'response_time' => 150,
        'response_body' => '{"test": "data"}',
        'requested_at' => now()
    ]);
    
    echo "✅ SUCCESS: ApiLog created successfully with ID: " . $apiLog->id . "\n";
    echo "📋 Details:\n";
    echo "   - API Source ID: " . $apiLog->api_source_id . "\n";
    echo "   - Endpoint: " . $apiLog->endpoint . "\n";
    echo "   - Method: " . $apiLog->method . "\n";
    echo "   - Status Code: " . $apiLog->status_code . "\n";
    echo "   - Response Time: " . $apiLog->response_time . "ms\n";
    echo "   - Created At: " . $apiLog->created_at . "\n";
    
} catch (Exception $e) {
    echo "❌ ERROR: " . $e->getMessage() . "\n";
    echo "📝 Stack trace:\n" . $e->getTraceAsString() . "\n";
} 