<?php
// Test if PostOnlyReceiverController is now working
echo "<h2>🧪 Testing PostOnlyReceiverController Fix</h2>";

try {
    // Step 1: Clear all cache
    echo "<h3>Step 1: Clearing All Cache</h3>";
    
    $commands = [
        'route:clear' => 'Route Cache',
        'config:clear' => 'Config Cache',
        'cache:clear' => 'Application Cache',
        'view:clear' => 'View Cache',
        'optimize:clear' => 'Optimized Files'
    ];
    
    foreach ($commands as $command => $name) {
        $result = shell_exec("php artisan $command 2>&1");
        $status = $result ? (strpos($result, 'cleared') !== false ? '✅' : '⚠️') : '✅';
        echo "<p>$status <strong>$name:</strong> " . ($result ?: 'Success') . "</p>";
    }
    
    // Step 2: Check if files exist
    echo "<h3>Step 2: Checking File Existence</h3>";
    
    $files = [
        'app/Http/Controllers/PostOnlyReceiverController.php' => 'Controller',
        'app/Models/PostOnlyReceiver.php' => 'PostOnlyReceiver Model',
        'app/Models/PostOnlyReceiveLog.php' => 'PostOnlyReceiveLog Model'
    ];
    
    foreach ($files as $file => $name) {
        if (file_exists(__DIR__ . '/' . $file)) {
            echo "<p style='color: green;'>✅ <strong>$name:</strong> Found</p>";
        } else {
            echo "<p style='color: red;'>❌ <strong>$name:</strong> Missing</p>";
        }
    }
    
    // Step 3: Test class existence
    echo "<h3>Step 3: Testing Class Existence</h3>";
    
    if (class_exists('App\\Http\\Controllers\\PostOnlyReceiverController')) {
        echo "<p style='color: green;'>✅ PostOnlyReceiverController class can be loaded</p>";
    } else {
        echo "<p style='color: red;'>❌ PostOnlyReceiverController class not found</p>";
    }
    
    if (class_exists('App\\Models\\PostOnlyReceiver')) {
        echo "<p style='color: green;'>✅ PostOnlyReceiver model can be loaded</p>";
    } else {
        echo "<p style='color: red;'>❌ PostOnlyReceiver model not found</p>";
    }
    
    if (class_exists('App\\Models\\PostOnlyReceiveLog')) {
        echo "<p style='color: green;'>✅ PostOnlyReceiveLog model can be loaded</p>";
    } else {
        echo "<p style='color: red;'>❌ PostOnlyReceiveLog model not found</p>";
    }
    
    // Step 4: Test route registration
    echo "<h3>Step 4: Testing Route Registration</h3>";
    
    $routeList = shell_exec('php artisan route:list --name=post-only-receivers.index 2>&1');
    if ($routeList && strpos($routeList, 'post-only-receivers.index') !== false) {
        echo "<p style='color: green;'>✅ post-only-receivers.index route is registered</p>";
    } else {
        echo "<p style='color: red;'>❌ post-only-receivers.index route not found</p>";
        echo "<p>Route list output: $routeList</p>";
    }
    
    // Step 5: Test route access
    echo "<h3>Step 5: Testing Route Access</h3>";
    
    $testUrl = $_SERVER['REQUEST_SCHEME'] . '://' . $_SERVER['HTTP_HOST'] . '/post-only-receivers';
    
    $context = stream_context_create([
        'http' => [
            'method' => 'GET',
            'header' => 'User-Agent: Controller Test',
            'timeout' => 10,
            'ignore_errors' => true
        ]
    ]);
    
    $response = @file_get_contents($testUrl, false, $context);
    $httpCode = isset($http_response_header[0]) ? $http_response_header[0] : 'No response';
    
    echo "<p><strong>Test URL:</strong> $testUrl</p>";
    echo "<p><strong>Response:</strong> $httpCode</p>";
    
    if (strpos($httpCode, '200') !== false) {
        echo "<p style='color: green;'>✅ Controller is working! Route accessible</p>";
    } else if (strpos($httpCode, '302') !== false) {
        echo "<p style='color: orange;'>⚠️ Route redirecting (authentication required) - Controller exists</p>";
    } else if (strpos($httpCode, '404') !== false) {
        echo "<p style='color: red;'>❌ Route still returns 404</p>";
    } else if (strpos($httpCode, '500') !== false) {
        echo "<p style='color: red;'>❌ Server error (500) - Check Laravel logs</p>";
        
        // Try to get more error details
        $errorDetails = shell_exec('tail -n 20 storage/logs/laravel.log 2>&1');
        if ($errorDetails) {
            echo "<p><strong>Recent Laravel Log:</strong></p>";
            echo "<pre style='background: #f8f9fa; padding: 10px; border-radius: 4px; max-height: 200px; overflow-y: auto;'>$errorDetails</pre>";
        }
    } else {
        echo "<p style='color: orange;'>⚠️ Unexpected response: $httpCode</p>";
    }
    
    // Step 6: Test autoload
    echo "<h3>Step 6: Testing Autoload</h3>";
    
    $autoloadTest = shell_exec('php artisan tinker --execute="echo class_exists(\\App\\Http\\Controllers\\PostOnlyReceiverController::class) ? \'YES\' : \'NO\';" 2>&1');
    if (trim($autoloadTest) === 'YES') {
        echo "<p style='color: green;'>✅ Controller can be autoloaded</p>";
    } else {
        echo "<p style='color: red;'>❌ Controller autoload failed: $autoloadTest</p>";
    }
    
    echo "<hr>";
    echo "<h3 style='color: blue;'>🎯 Summary</h3>";
    echo "<p>Controller files have been uploaded and cache cleared.</p>";
    
} catch (Exception $e) {
    echo "<p style='color: red;'>❌ Error: " . $e->getMessage() . "</p>";
}

echo "<hr>";
echo "<h3>📋 Next Steps:</h3>";
echo "<ol>";
echo "<li>Try accessing the application again</li>";
echo "<li>If still getting controller errors, check composer autoload</li>";
echo "<li>Check Laravel logs for detailed error information</li>";
echo "<li>Consider running 'composer dump-autoload' if needed</li>";
echo "</ol>";

echo "<p><strong>Test completed at:</strong> " . date('Y-m-d H:i:s') . "</p>";
?> 