<?php

require_once 'vendor/autoload.php';

// Bootstrap Laravel
$app = require_once 'bootstrap/app.php';
$app->make(Illuminate\Contracts\Console\Kernel::class)->bootstrap();

use App\Models\ApiToken;
use App\Models\GetOnlyReceiver;

echo "Testing GET-Only Receivers functionality...\n\n";

try {
    // Test 1: Query ApiToken dengan kondisi yang benar
    echo "Test 1: Querying active ApiTokens...\n";
    $activeTokens = ApiToken::where('is_revoked', false)
        ->where(function($query) {
            $query->whereNull('expires_at')
                  ->orWhere('expires_at', '>', now());
        })
        ->get();
    
    echo "Found " . $activeTokens->count() . " active tokens\n";
    echo "✓ ApiToken query berhasil!\n\n";
    
    // Test 2: Query GetOnlyReceiver
    echo "Test 2: Querying GetOnlyReceivers...\n";
    $receivers = GetOnlyReceiver::where('is_active', true)->get();
    echo "Found " . $receivers->count() . " active receivers\n";
    echo "✓ GetOnlyReceiver query berhasil!\n\n";
    
    // Test 3: Test token validation method
    echo "Test 3: Testing token validation method...\n";
    if ($receivers->count() > 0) {
        $receiver = $receivers->first();
        $isValid = $receiver->isTokenValid('test-token');
        echo "Token validation test: " . ($isValid ? "Valid" : "Invalid") . "\n";
        echo "✓ Token validation method berhasil!\n\n";
    }
    
    echo "✅ Semua test berhasil! Error 'is_active' column not found sudah teratasi.\n";
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
    echo "Trace: " . $e->getTraceAsString() . "\n";
} 