<?php
// Simple test script to verify import route is working
echo "<h2>🧪 Testing Import Route</h2>";

// Test 1: Basic connectivity
echo "<h3>Test 1: Basic Connectivity</h3>";
$testUrl = "https://copilotproduction.site/api-test";
$response = @file_get_contents($testUrl);
if ($response) {
    echo "<p style='color: green;'>✅ Basic connectivity: OK</p>";
} else {
    echo "<p style='color: red;'>❌ Basic connectivity: FAILED</p>";
}

// Test 2: Check if emergency import route exists
echo "<h3>Test 2: Emergency Import Route Test</h3>";
$importUrl = "https://copilotproduction.site/import-data/1";
$context = stream_context_create([
    'http' => [
        'method' => 'POST',
        'header' => 'Content-Type: application/json',
        'content' => '{}',
        'ignore_errors' => true
    ]
]);

$response = @file_get_contents($importUrl, false, $context);
$httpCode = isset($http_response_header[0]) ? $http_response_header[0] : 'No response';

echo "<p><strong>Response:</strong> $httpCode</p>";
if (strpos($httpCode, '404') !== false) {
    echo "<p style='color: red;'>❌ Import route not found (404)</p>";
} else if (strpos($httpCode, '419') !== false) {
    echo "<p style='color: orange;'>⚠️ CSRF token missing (419) - Route exists but needs token</p>";
} else if (strpos($httpCode, '500') !== false) {
    echo "<p style='color: orange;'>⚠️ Server error (500) - Route exists but has issues</p>";
} else {
    echo "<p style='color: green;'>✅ Import route responding</p>";
}

// Test 3: Show available routes
echo "<h3>Test 3: Route Debug</h3>";
$debugUrl = "https://copilotproduction.site/debug-routes";
$debugResponse = @file_get_contents($debugUrl);
if ($debugResponse) {
    echo "<p style='color: green;'>✅ Debug routes accessible</p>";
    echo "<p><a href='$debugUrl' target='_blank'>View Debug Routes</a></p>";
} else {
    echo "<p style='color: red;'>❌ Debug routes not accessible</p>";
}

// Test 4: Cache clearing
echo "<h3>Test 4: Cache Clearing</h3>";
$cacheUrl = "https://copilotproduction.site/clear-all-cache";
$cacheResponse = @file_get_contents($cacheUrl);
if ($cacheResponse && strpos($cacheResponse, 'Cache Cleared') !== false) {
    echo "<p style='color: green;'>✅ Cache clearing works</p>";
} else {
    echo "<p style='color: red;'>❌ Cache clearing failed</p>";
}

echo "<hr>";
echo "<h3>📋 Next Steps:</h3>";
echo "<ol>";
echo "<li>If import route shows 404: Visit <a href='https://copilotproduction.site/clear-all-cache'>Clear Cache</a></li>";
echo "<li>If import route shows 419: CSRF token issue - check browser console</li>";
echo "<li>If import route shows 500: Server error - check Laravel logs</li>";
echo "<li>Test import function in browser after clearing cache</li>";
echo "</ol>";

echo "<p><strong>Test completed at:</strong> " . date('Y-m-d H:i:s') . "</p>";
?> 