<?php

require_once 'vendor/autoload.php';

// Bootstrap Laravel
$app = require_once 'bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

try {
    echo "🧪 Testing API Logs functionality...\n\n";
    
    // Get the first API source
    $apiSource = App\Models\ApiSource::first();
    
    if (!$apiSource) {
        echo "❌ No API Source found. Creating one...\n";
        $apiSource = App\Models\ApiSource::create([
            'name' => 'Test API Source',
            'url' => 'https://jsonplaceholder.typicode.com/users',
            'method' => 'GET',
            'table_name' => 'test_data',
            'auth_type' => 'none',
            'schedule_type' => 'manual',
            'status' => 'active'
        ]);
        echo "✅ Created API Source with ID: {$apiSource->id}\n";
    }
    
    // Test creating a successful log
    echo "📝 Creating successful log entry...\n";
    $successLog = App\Models\ApiLog::create([
        'api_source_id' => $apiSource->id,
        'endpoint' => $apiSource->url,
        'method' => 'GET',
        'status_code' => 200,
        'response_code' => 200,
        'status' => 'success',
        'response_time' => 150,
        'response_body' => json_encode(['data' => 'test']),
        'records_imported' => 5,
        'requested_at' => now()
    ]);
    echo "✅ Success log created with ID: {$successLog->id}\n";
    
    // Test creating an error log
    echo "📝 Creating error log entry...\n";
    $errorLog = App\Models\ApiLog::create([
        'api_source_id' => $apiSource->id,
        'endpoint' => $apiSource->url,
        'method' => 'GET',
        'status_code' => 500,
        'response_code' => 500,
        'status' => 'error',
        'response_time' => 0,
        'records_imported' => 0,
        'error_message' => 'Connection timeout',
        'requested_at' => now()
    ]);
    echo "✅ Error log created with ID: {$errorLog->id}\n";
    
    // Test the queries that were failing in the view
    echo "\n🔍 Testing the queries used in the logs view...\n";
    
    $successCount = $apiSource->apiLogs()->where('status', 'success')->count();
    echo "✅ Success logs count: {$successCount}\n";
    
    $errorCount = $apiSource->apiLogs()->where('status', 'error')->count();
    echo "✅ Error logs count: {$errorCount}\n";
    
    $totalRecords = $apiSource->apiLogs()->where('status', 'success')->sum('records_imported');
    echo "✅ Total records imported: {$totalRecords}\n";
    
    echo "\n🎉 All tests passed! The logs page should now work correctly.\n";
    
} catch (Exception $e) {
    echo "❌ ERROR: " . $e->getMessage() . "\n";
    echo "📝 Stack trace:\n" . $e->getTraceAsString() . "\n";
} 