Write-Host "=== TEST KONEKSI DENGAN KREDENSIAL BARU ===" -ForegroundColor Yellow
Write-Host "===========================================" -ForegroundColor Yellow

$server = "copilotproduction.site"
$username = "copg1493"
$password = "wPD6DDSegDHd56"

# Test 1: DNS & Basic Connectivity
Write-Host "DNS: " -NoNewline
try {
    $dns = [System.Net.Dns]::GetHostEntry($server)
    Write-Host "OK ($($dns.AddressList[0]))" -ForegroundColor Green
} catch {
    Write-Host "FAILED" -ForegroundColor Red
}

# Test 2: Ping
Write-Host "PING: " -NoNewline
$ping = Test-Connection -ComputerName $server -Count 1 -Quiet
if ($ping) {
    Write-Host "OK" -ForegroundColor Green
} else {
    Write-Host "FAILED" -ForegroundColor Red
}

# Test 3: Port 21
Write-Host "PORT 21: " -NoNewline
$port21 = Test-NetConnection -ComputerName $server -Port 21 -WarningAction SilentlyContinue
if ($port21.TcpTestSucceeded) {
    Write-Host "OPEN" -ForegroundColor Green
} else {
    Write-Host "CLOSED" -ForegroundColor Red
}

# Test 4: FTP Login dengan kredensial baru
Write-Host "FTP LOGIN (NEW): " -NoNewline
try {
    $ftp = [System.Net.FtpWebRequest]::Create("ftp://$server/")
    $ftp.Credentials = New-Object System.Net.NetworkCredential($username, $password)
    $ftp.Method = [System.Net.WebRequestMethods+Ftp]::PrintWorkingDirectory
    $ftp.Timeout = 15000
    $ftp.UsePassive = $true
    $ftp.KeepAlive = $false
    
    $response = $ftp.GetResponse()
    Write-Host "SUCCESS!" -ForegroundColor Green
    Write-Host "Status: $($response.StatusDescription)" -ForegroundColor Green
    $response.Close()
    
    # Test directory listing jika login berhasil
    Write-Host "DIRECTORY LIST: " -NoNewline
    try {
        $ftpList = [System.Net.FtpWebRequest]::Create("ftp://$server/")
        $ftpList.Credentials = New-Object System.Net.NetworkCredential($username, $password)
        $ftpList.Method = [System.Net.WebRequestMethods+Ftp]::ListDirectory
        $ftpList.UsePassive = $true
        $ftpList.KeepAlive = $false
        
        $listResponse = $ftpList.GetResponse()
        $stream = $listResponse.GetResponseStream()
        $reader = New-Object System.IO.StreamReader($stream)
        $listing = $reader.ReadToEnd()
        
        Write-Host "SUCCESS" -ForegroundColor Green
        Write-Host "Files/Folders found:" -ForegroundColor Cyan
        Write-Host $listing -ForegroundColor White
        
        $reader.Close()
        $stream.Close()
        $listResponse.Close()
    } catch {
        Write-Host "FAILED ($($_.Exception.Message.Split('.')[0]))" -ForegroundColor Red
    }
    
} catch {
    Write-Host "FAILED" -ForegroundColor Red
    Write-Host "Error: $($_.Exception.Message)" -ForegroundColor Red
}

Write-Host "===========================================" -ForegroundColor Yellow
Write-Host "Kredensial yang digunakan:" -ForegroundColor Cyan
Write-Host "Username: $username" -ForegroundColor White
Write-Host "Password: $password" -ForegroundColor White
Write-Host "Server: $server" -ForegroundColor White 