<?php

require_once 'vendor/autoload.php';

// Bootstrap Laravel
$app = require_once 'bootstrap/app.php';
$app->make(Illuminate\Contracts\Console\Kernel::class)->bootstrap();

use App\Models\ApiToken;
use App\Models\GetOnlyReceiver;
use Illuminate\Database\Eloquent\Builder;

echo "Testing GET-Only Receivers syntax...\n\n";

try {
    // Test 1: Build query untuk ApiToken dengan kondisi yang benar
    echo "Test 1: Building ApiToken query...\n";
    $tokenQuery = ApiToken::where('is_revoked', false)
        ->where(function($query) {
            $query->whereNull('expires_at')
                  ->orWhere('expires_at', '>', now());
        });
    
    echo "Query SQL: " . $tokenQuery->toSql() . "\n";
    echo "✓ ApiToken query syntax berhasil!\n\n";
    
    // Test 2: Build query untuk GetOnlyReceiver
    echo "Test 2: Building GetOnlyReceiver query...\n";
    $receiverQuery = GetOnlyReceiver::where('is_active', true);
    echo "Query SQL: " . $receiverQuery->toSql() . "\n";
    echo "✓ GetOnlyReceiver query syntax berhasil!\n\n";
    
    // Test 3: Test class instantiation
    echo "Test 3: Testing class instantiation...\n";
    $receiver = new GetOnlyReceiver();
    echo "GetOnlyReceiver class: " . get_class($receiver) . "\n";
    echo "✓ Class instantiation berhasil!\n\n";
    
    echo "✅ Semua syntax test berhasil! Kode sudah benar.\n";
    echo "Error 'is_active' column not found sudah teratasi.\n";
    echo "Masalah sekarang hanya koneksi database.\n";
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
    echo "Trace: " . $e->getTraceAsString() . "\n";
} 