<?php

// Test API endpoint directly
echo "=== Test API Endpoint ===\n";

$url = 'https://copilotproduction.site/api/in/baden';
$username = 'baden';
$password = 'baden';
$credentials = base64_encode($username . ':' . $password);

echo "URL: $url\n";
echo "Username: $username\n";
echo "Password: $password\n";
echo "Credentials: $credentials\n";
echo "Auth Header: Basic $credentials\n\n";

// Test with cURL
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode(['test' => 'data']));
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Authorization: Basic ' . $credentials,
    'Content-Type: application/json',
    'Accept: application/json'
]);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);

echo "Sending request...\n";
$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

echo "HTTP Code: $httpCode\n";
if ($error) {
    echo "cURL Error: $error\n";
}

echo "Response:\n$response\n\n";

// Test with different credentials
echo "=== Test with different credentials ===\n";
$testCredentials = [
    ['username' => 'baden', 'password' => 'baden'],
    ['username' => 'admin', 'password' => 'admin'],
    ['username' => 'test', 'password' => 'test'],
    ['username' => 'user', 'password' => 'pass']
];

foreach ($testCredentials as $cred) {
    $testUsername = $cred['username'];
    $testPassword = $cred['password'];
    $testAuth = base64_encode($testUsername . ':' . $testPassword);
    
    echo "Testing: $testUsername:$testPassword\n";
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode(['test' => 'data']));
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Authorization: Basic ' . $testAuth,
        'Content-Type: application/json',
        'Accept: application/json'
    ]);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    echo "HTTP Code: $httpCode\n";
    echo "Response: " . substr($response, 0, 200) . "\n\n";
}
