<?php

require_once 'vendor/autoload.php';

$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

use App\Models\ApiTarget;
use App\Models\User;

echo "=== API TARGET TEST ===\n\n";

try {
    // Get first user
    $user = User::first();
    echo "User: {$user->name} ({$user->email})\n";
    
    // Create API Target
    $target = ApiTarget::create([
        'name' => 'Test API Target',
        'description' => 'Testing target',
        'base_url' => 'https://httpbin.org',
        'endpoint' => '/post',
        'method' => 'POST',
        'source_table' => 'users',
        'auth_type' => 'none',
        'schedule_type' => 'manual',
        'is_active' => true,
        'created_by' => $user->id
    ]);
    
    echo "API Target created!\n";
    echo "ID: {$target->id}\n";
    echo "Name: {$target->name}\n";
    echo "URL: {$target->url}\n";
    echo "Method: {$target->method}\n";
    
    // Test URL attribute
    echo "\nURL Test:\n";
    echo "Base URL: {$target->base_url}\n";
    echo "Endpoint: {$target->endpoint}\n";
    echo "Full URL: {$target->url}\n";
    
    // Check users data
    $userCount = User::count();
    echo "\nUsers in database: {$userCount}\n";
    
    echo "\n=== NEXT STEPS ===\n";
    echo "1. Open: http://127.0.0.1:8000/api-targets\n";
    echo "2. Login and test the Send Data feature\n";
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
} 