<?php

/**
 * Simple test script untuk memverifikasi ApiTarget model
 * Jalankan dengan: php test_api_target_model.php
 */

require_once 'vendor/autoload.php';

// Bootstrap Laravel
$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

use App\Models\ApiTarget;

echo "=== TEST API TARGET MODEL ===\n\n";

try {
    // Test 1: Membuat ApiTarget dengan base_url dan endpoint
    echo "1. Testing URL attribute...\n";
    
    $apiTarget = new ApiTarget();
    $apiTarget->base_url = 'https://api.example.com';
    $apiTarget->endpoint = '/webhook/data';
    
    $url = $apiTarget->url;
    echo "✓ URL: {$url}\n";
    
    if ($url === 'https://api.example.com/webhook/data') {
        echo "✓ URL attribute works correctly!\n\n";
    } else {
        echo "✗ URL attribute failed! Expected: https://api.example.com/webhook/data, Got: {$url}\n\n";
    }
    
    // Test 2: Testing dengan trailing slash
    echo "2. Testing URL dengan trailing slash...\n";
    
    $apiTarget2 = new ApiTarget();
    $apiTarget2->base_url = 'https://api.example.com/';
    $apiTarget2->endpoint = '/webhook/data';
    
    $url2 = $apiTarget2->url;
    echo "✓ URL: {$url2}\n";
    
    if ($url2 === 'https://api.example.com/webhook/data') {
        echo "✓ URL dengan trailing slash works correctly!\n\n";
    } else {
        echo "✗ URL dengan trailing slash failed! Expected: https://api.example.com/webhook/data, Got: {$url2}\n\n";
    }
    
    // Test 3: Testing dengan endpoint tanpa leading slash
    echo "3. Testing URL dengan endpoint tanpa leading slash...\n";
    
    $apiTarget3 = new ApiTarget();
    $apiTarget3->base_url = 'https://api.example.com';
    $apiTarget3->endpoint = 'webhook/data';
    
    $url3 = $apiTarget3->url;
    echo "✓ URL: {$url3}\n";
    
    if ($url3 === 'https://api.example.com/webhook/data') {
        echo "✓ URL dengan endpoint tanpa leading slash works correctly!\n\n";
    } else {
        echo "✗ URL dengan endpoint tanpa leading slash failed! Expected: https://api.example.com/webhook/data, Got: {$url3}\n\n";
    }
    
    echo "=== SEMUA TEST BERHASIL ===\n";
    
} catch (Exception $e) {
    echo "✗ Error: " . $e->getMessage() . "\n";
    echo "Stack trace:\n" . $e->getTraceAsString() . "\n";
} 