<?php
// Test script to verify auth_type enum fix
require_once 'vendor/autoload.php';

// Load Laravel app
$app = require_once 'bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

try {
    // Test creating an API receiver with basic_auth
    $testData = [
        'name' => 'Test Basic Auth Receiver',
        'description' => 'Test receiver for basic auth',
        'endpoint' => 'test-basic-auth-' . time(),
        'target_table' => 'customers',
        'auth_type' => 'basic_auth',  // This was causing the truncation error
        'auth_username' => 'testuser',
        'auth_password' => 'testpass',
        'allowed_methods' => 'GET,POST',
        'field_mapping' => json_encode(['name' => 'name', 'email' => 'email']),
        'response_format' => 'json',
        'rate_limit' => 60,
        'auto_create_table' => false,
        'is_active' => true,
        'duplicate_handling' => 'skip',
        'unique_fields' => 'id',
        'data_filter' => 'latest_only',
        'max_records_per_request' => 50,
        'is_bidirectional' => false,
        'auto_acknowledge' => true,
        'retry_attempts' => 3,
        'retry_delay' => 60,
        'enable_scheduling' => false,
        'schedule_type' => 'manual',
        'schedule_interval' => 60,
        'schedule_time' => '00:00',
        'total_received' => 0,
        'total_callbacks_sent' => 0,
        'total_callbacks_failed' => 0,
        'timezone' => 'Asia/Jakarta',
        'active_hours_start' => '00:00',
        'active_hours_end' => '23:59'
    ];

    echo "Attempting to create API Receiver with basic_auth...\n";
    
    $receiver = App\Models\ApiReceiver::create($testData);
    
    echo "SUCCESS! API Receiver created with ID: " . $receiver->id . "\n";
    echo "Auth type: " . $receiver->auth_type . "\n";
    echo "Endpoint: " . $receiver->endpoint . "\n";
    
    // Clean up - delete the test receiver
    $receiver->delete();
    echo "Test receiver cleaned up.\n";
    echo "\nFix verified! The auth_type enum now accepts 'basic_auth' values.\n";
    
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
    echo "The fix may not have been applied correctly.\n";
}
?>
