<?php
// Test script untuk memverifikasi semua auth_type bekerja
// Jalankan dengan: php test_auth_types.php

require_once 'vendor/autoload.php';
$app = require_once 'bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

$authTypes = ['none', 'api_key', 'bearer_token', 'basic_auth', 'hmac_signature'];

echo "Testing all auth_type values...\n\n";

foreach ($authTypes as $authType) {
    try {
        $testData = [
            'name' => "Test {$authType} Receiver",
            'endpoint' => "test-{$authType}-" . time() . rand(100, 999),
            'target_table' => 'customers',
            'auth_type' => $authType,
            'allowed_methods' => 'GET,POST',
            'is_active' => true,
            'duplicate_handling' => 'skip',
            'unique_fields' => 'id',
            'data_filter' => 'latest_only',
            'max_records_per_request' => 50,
        ];

        $receiver = App\Models\ApiReceiver::create($testData);
        echo "✅ SUCCESS: {$authType} - ID: {$receiver->id}\n";
        
        // Clean up
        $receiver->delete();
        
    } catch (Exception $e) {
        echo "❌ FAILED: {$authType} - Error: " . $e->getMessage() . "\n";
    }
}

echo "\nTest completed!\n";
?>
