<?php

// Simple test script to check Baden receiver configuration
echo "=== Test Baden Receiver Configuration ===\n";

try {
    // Test database connection
    $host = '127.0.0.1';
    $dbname = 'copg1493_api';
    $username = 'copg1493_api';
    $password = 'P7H_s;Aco25Vv??J';
    
    echo "Testing database connection...\n";
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    echo "✅ Database connection successful\n\n";
    
    // Check if api_receivers table exists
    $stmt = $pdo->query("SHOW TABLES LIKE 'api_receivers'");
    if ($stmt->rowCount() == 0) {
        echo "❌ Table 'api_receivers' not found\n";
        exit;
    }
    echo "✅ Table 'api_receivers' exists\n\n";
    
    // Check Baden receiver
    $stmt = $pdo->prepare("SELECT * FROM api_receivers WHERE endpoint = ?");
    $stmt->execute(['baden']);
    $receiver = $stmt->fetch(PDO::FETCH_OBJ);
    
    if (!$receiver) {
        echo "❌ Receiver 'baden' not found in database\n";
        echo "Creating Baden receiver...\n";
        
        $insertStmt = $pdo->prepare("
            INSERT INTO api_receivers (
                name, description, endpoint, target_table, 
                auth_type, auth_username, auth_password,
                allowed_methods, is_active, created_at, updated_at
            ) VALUES (
                ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW(), NOW()
            )
        ");
        
        $insertStmt->execute([
            'Baden Basic Auth Receiver',
            'Receiver for Baden System with Basic Authentication',
            'baden',
            'orders',
            'basic_auth',
            'baden',
            'baden',
            'GET,POST,PUT,DELETE',
            1
        ]);
        
        echo "✅ Baden receiver created successfully\n";
        
        // Fetch the newly created receiver
        $stmt = $pdo->prepare("SELECT * FROM api_receivers WHERE endpoint = ?");
        $stmt->execute(['baden']);
        $receiver = $stmt->fetch(PDO::FETCH_OBJ);
    }
    
    echo "✅ Baden receiver found:\n";
    echo "ID: {$receiver->id}\n";
    echo "Name: {$receiver->name}\n";
    echo "Endpoint: {$receiver->endpoint}\n";
    echo "Auth Type: {$receiver->auth_type}\n";
    echo "Username: " . ($receiver->auth_username ?? 'NULL') . "\n";
    echo "Password: " . ($receiver->auth_password ?? 'NULL') . "\n";
    echo "Is Active: " . ($receiver->is_active ? 'Yes' : 'No') . "\n\n";
    
    // Test Basic Auth logic
    echo "=== Test Basic Auth Logic ===\n";
    $testUsername = 'baden';
    $testPassword = 'baden';
    $authHeader = 'Basic ' . base64_encode($testUsername . ':' . $testPassword);
    
    echo "Test Username: '$testUsername'\n";
    echo "Test Password: '$testPassword'\n";
    echo "Auth Header: '$authHeader'\n\n";
    
    // Simulate authentication process
    if (str_starts_with($authHeader, 'Basic ')) {
        $credentials = base64_decode(substr($authHeader, 6));
        $parts = explode(':', $credentials, 2);
        
        if (count($parts) === 2) {
            $username = $parts[0];
            $password = $parts[1];
            
            echo "Extracted username: '$username'\n";
            echo "Extracted password: '$password'\n";
            echo "Stored username: '" . ($receiver->auth_username ?? 'NULL') . "'\n";
            echo "Stored password: '" . ($receiver->auth_password ?? 'NULL') . "'\n";
            
            $usernameMatch = $username === ($receiver->auth_username ?? '');
            $passwordMatch = $password === ($receiver->auth_password ?? '');
            
            echo "Username match: " . ($usernameMatch ? 'YES' : 'NO') . "\n";
            echo "Password match: " . ($passwordMatch ? 'YES' : 'NO') . "\n";
            
            if ($usernameMatch && $passwordMatch) {
                echo "✅ Basic Auth should work!\n";
            } else {
                echo "❌ Basic Auth will fail!\n";
            }
        }
    }
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
}
