<?php

// Test Basic Auth untuk endpoint /api/in/baden
$url = 'https://copilotproduction.site/api/in/baden';
$username = 'baden';
$password = 'baden';

// Encode credentials untuk Basic Auth
$credentials = base64_encode($username . ':' . $password);

// Headers
$headers = [
    'Authorization: Basic ' . $credentials,
    'Content-Type: application/json',
    'Accept: application/json'
];

// Test data
$data = [
    'order_id' => 'TEST-' . time(),
    'customer_name' => 'Test Customer',
    'total_amount' => 100.50
];

// Initialize cURL
$ch = curl_init();

// Set cURL options
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);

// Execute request
$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);

// Close cURL
curl_close($ch);

// Output results
echo "=== Basic Auth Test Results ===\n";
echo "URL: $url\n";
echo "Username: $username\n";
echo "Password: $password\n";
echo "Encoded Credentials: $credentials\n";
echo "HTTP Code: $httpCode\n";

if ($error) {
    echo "cURL Error: $error\n";
}

echo "Response:\n";
echo $response . "\n";

// Decode response
$responseData = json_decode($response, true);
if ($responseData) {
    echo "\nDecoded Response:\n";
    print_r($responseData);
}
