<?php

// Test Basic Auth untuk endpoint /api/in/baden yang sudah diperbaiki
$url = 'https://copilotproduction.site/api/in/baden';
$username = 'baden';
$password = 'baden';

// Encode credentials untuk Basic Auth
$credentials = base64_encode($username . ':' . $password);

// Headers
$headers = [
    'Authorization: Basic ' . $credentials,
    'Content-Type: application/json',
    'Accept: application/json'
];

// Test data
$data = [
    'order_id' => 'TEST-' . time(),
    'customer_name' => 'Test Customer',
    'total_amount' => 100.50
];

echo "=== Testing Basic Auth untuk Baden ===\n";
echo "URL: $url\n";
echo "Username: $username\n";
echo "Password: $password\n";
echo "Encoded Credentials: $credentials\n";
echo "Authorization Header: Basic $credentials\n\n";

// Initialize cURL
$ch = curl_init();

// Set cURL options
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);
curl_setopt($ch, CURLOPT_VERBOSE, true);

// Execute request
$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);

// Close cURL
curl_close($ch);

// Output results
echo "=== Hasil Test ===\n";
echo "HTTP Code: $httpCode\n";

if ($error) {
    echo "❌ cURL Error: $error\n";
}

echo "Response:\n";
echo $response . "\n";

// Decode response
$responseData = json_decode($response, true);
if ($responseData) {
    echo "\nDecoded Response:\n";
    print_r($responseData);
    
    if ($httpCode === 200 || $httpCode === 201) {
        echo "\n✅ SUCCESS! Basic Auth berhasil!\n";
    } else {
        echo "\n❌ Masih ada masalah dengan Basic Auth\n";
    }
} else {
    echo "\n❌ Response tidak valid JSON\n";
}
