<?php
/**
 * Script untuk test API dengan Bearer token
 * Jalankan dengan: php test_bearer_token.php
 */

// Ganti dengan URL dan token yang sesuai
$apiUrl = 'http://localhost/api8-fix/api/cilentapi'; // Ganti dengan URL API Anda
$bearerToken = 'at_xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx'; // Ganti dengan token Anda

echo "=== TEST BEARER TOKEN API ===\n\n";

// Test dengan GET request
echo "1. Testing GET request...\n";
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $apiUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Authorization: Bearer ' . $bearerToken,
    'Content-Type: application/json',
    'Accept: application/json'
]);
curl_setopt($ch, CURLOPT_VERBOSE, true);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

echo "   HTTP Code: {$httpCode}\n";
if ($error) {
    echo "   cURL Error: {$error}\n";
}
echo "   Response: " . substr($response, 0, 500) . "\n\n";

// Test dengan POST request
echo "2. Testing POST request...\n";
$postData = json_encode([
    'test' => 'data',
    'timestamp' => date('Y-m-d H:i:s')
]);

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $apiUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Authorization: Bearer ' . $bearerToken,
    'Content-Type: application/json',
    'Accept: application/json'
]);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

echo "   HTTP Code: {$httpCode}\n";
if ($error) {
    echo "   cURL Error: {$error}\n";
}
echo "   Response: " . substr($response, 0, 500) . "\n\n";

// Test dengan query parameter (fallback)
echo "3. Testing with query parameter...\n";
$urlWithToken = $apiUrl . '?token=' . $bearerToken;

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $urlWithToken);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json',
    'Accept: application/json'
]);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

echo "   HTTP Code: {$httpCode}\n";
if ($error) {
    echo "   cURL Error: {$error}\n";
}
echo "   Response: " . substr($response, 0, 500) . "\n\n";

echo "=== TEST COMPLETE ===\n";
