<?php
/**
 * Test GET Request dengan Body Data Raw
 * Contoh: {"data": "customer"}
 */

// Konfigurasi
$baseUrl = 'http://localhost/api8-fix/public'; // Sesuaikan dengan URL Anda
$endpoint = 'test12'; // Endpoint untuk testing

echo "=== TEST GET REQUEST DENGAN BODY DATA ===\n\n";

// Test 1: GET dengan body data sederhana
echo "1. Test GET dengan body data sederhana:\n";
echo "Request: GET /api/in/{$endpoint}\n";
echo "Body: {\"data\": \"customer\"}\n\n";

$ch = curl_init();
curl_setopt_array($ch, [
    CURLOPT_URL => "{$baseUrl}/api/in/{$endpoint}",
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_CUSTOMREQUEST => 'GET',
    CURLOPT_POSTFIELDS => json_encode(['data' => 'customer']),
    CURLOPT_HTTPHEADER => [
        'Content-Type: application/json',
        'Accept: application/json'
    ]
]);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "Response Code: {$httpCode}\n";
echo "Response Body:\n";
echo json_encode(json_decode($response, true), JSON_PRETTY_PRINT);
echo "\n\n";

// Test 2: GET dengan body data kompleks
echo "2. Test GET dengan body data kompleks:\n";
echo "Request: GET /api/in/{$endpoint}\n";
echo "Body: {\"data\": \"customer\", \"id\": 123, \"name\": \"John Doe\"}\n\n";

$ch = curl_init();
curl_setopt_array($ch, [
    CURLOPT_URL => "{$baseUrl}/api/in/{$endpoint}",
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_CUSTOMREQUEST => 'GET',
    CURLOPT_POSTFIELDS => json_encode([
        'data' => 'customer',
        'id' => 123,
        'name' => 'John Doe',
        'email' => 'john@example.com'
    ]),
    CURLOPT_HTTPHEADER => [
        'Content-Type: application/json',
        'Accept: application/json'
    ]
]);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "Response Code: {$httpCode}\n";
echo "Response Body:\n";
echo json_encode(json_decode($response, true), JSON_PRETTY_PRINT);
echo "\n\n";

// Test 3: GET dengan body data array
echo "3. Test GET dengan body data array:\n";
echo "Request: GET /api/in/{$endpoint}\n";
echo "Body: {\"data\": [\"customer1\", \"customer2\"]}\n\n";

$ch = curl_init();
curl_setopt_array($ch, [
    CURLOPT_URL => "{$baseUrl}/api/in/{$endpoint}",
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_CUSTOMREQUEST => 'GET',
    CURLOPT_POSTFIELDS => json_encode([
        'data' => ['customer1', 'customer2'],
        'type' => 'array_test'
    ]),
    CURLOPT_HTTPHEADER => [
        'Content-Type: application/json',
        'Accept: application/json'
    ]
]);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "Response Code: {$httpCode}\n";
echo "Response Body:\n";
echo json_encode(json_decode($response, true), JSON_PRETTY_PRINT);
echo "\n\n";

// Test 4: GET dengan body data dan query parameters
echo "4. Test GET dengan body data + query parameters:\n";
echo "Request: GET /api/in/{$endpoint}?debug=true&format=json\n";
echo "Body: {\"data\": \"customer\"}\n\n";

$ch = curl_init();
curl_setopt_array($ch, [
    CURLOPT_URL => "{$baseUrl}/api/in/{$endpoint}?debug=true&format=json",
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_CUSTOMREQUEST => 'GET',
    CURLOPT_POSTFIELDS => json_encode(['data' => 'customer']),
    CURLOPT_HTTPHEADER => [
        'Content-Type: application/json',
        'Accept: application/json'
    ]
]);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "Response Code: {$httpCode}\n";
echo "Response Body:\n";
echo json_encode(json_decode($response, true), JSON_PRETTY_PRINT);
echo "\n\n";

echo "=== PENJELASAN ===\n";
echo "1. Sistem mendukung GET request dengan body data\n";
echo "2. Data raw JSON akan diproses seperti POST request\n";
echo "3. Response akan menampilkan data yang dikirim\n";
echo "4. Data bisa disimpan ke database jika target_table dikonfigurasi\n";
echo "5. Query parameters tetap bisa digunakan bersamaan dengan body data\n\n";

echo "=== CURL COMMANDS ===\n";
echo "Untuk testing manual, gunakan command curl berikut:\n\n";

echo "# Test 1: GET dengan body data sederhana\n";
echo "curl -X GET '{$baseUrl}/api/in/{$endpoint}' \\\n";
echo "  -H 'Content-Type: application/json' \\\n";
echo "  -d '{\"data\": \"customer\"}'\n\n";

echo "# Test 2: GET dengan body data kompleks\n";
echo "curl -X GET '{$baseUrl}/api/in/{$endpoint}' \\\n";
echo "  -H 'Content-Type: application/json' \\\n";
echo "  -d '{\"data\": \"customer\", \"id\": 123, \"name\": \"John Doe\"}'\n\n";

echo "# Test 3: GET dengan debug mode\n";
echo "curl -X GET '{$baseUrl}/api/in/{$endpoint}?debug_storage=true' \\\n";
echo "  -H 'Content-Type: application/json' \\\n";
echo "  -d '{\"data\": \"customer\"}'\n\n";
?>
