<?php

// File untuk mengupdate receiver Baden dengan Basic Auth
// Jalankan file ini di hosting untuk memperbaiki konfigurasi

require_once 'vendor/autoload.php';

$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

use App\Models\ApiReceiver;

try {
    // Cari receiver dengan endpoint 'baden'
    $receiver = ApiReceiver::where('endpoint', 'baden')->first();
    
    if ($receiver) {
        echo "Receiver 'baden' ditemukan:\n";
        echo "ID: {$receiver->id}\n";
        echo "Name: {$receiver->name}\n";
        echo "Current Auth Type: {$receiver->auth_type}\n";
        echo "Current Username: {$receiver->auth_username}\n";
        echo "Current Password: {$receiver->auth_password}\n";
        echo "Is Active: " . ($receiver->is_active ? 'Yes' : 'No') . "\n";
        
        // Update ke Basic Auth
        $receiver->update([
            'auth_type' => 'basic_auth',
            'auth_username' => 'baden',
            'auth_password' => 'baden',
            'is_active' => true,
            'allowed_methods' => 'GET,POST,PUT,DELETE'
        ]);
        
        echo "\n✅ Receiver berhasil diupdate!\n";
        echo "New Auth Type: {$receiver->auth_type}\n";
        echo "New Username: {$receiver->auth_username}\n";
        echo "New Password: {$receiver->auth_password}\n";
        echo "Basic Auth Header: Basic " . base64_encode('baden:baden') . "\n";
        echo "Endpoint: https://copilotproduction.site/api/in/baden\n";
        
    } else {
        echo "❌ Receiver dengan endpoint 'baden' tidak ditemukan!\n";
        echo "Membuat receiver baru...\n";
        
        $receiver = ApiReceiver::create([
            'name' => 'Baden Basic Auth Receiver',
            'description' => 'Receiver for Baden System with Basic Authentication',
            'endpoint' => 'baden',
            'target_table' => 'orders',
            'auth_type' => 'basic_auth',
            'auth_username' => 'baden',
            'auth_password' => 'baden',
            'allowed_methods' => 'GET,POST,PUT,DELETE',
            'rate_limit' => 100,
            'auto_create_table' => true,
            'is_active' => true,
            'is_bidirectional' => true,
            'duplicate_handling' => 'update',
            'unique_fields' => 'order_id',
            'data_filter' => 'all',
            'max_records_per_request' => 100,
            'enable_scheduling' => true,
            'schedule_type' => 'interval',
            'schedule_interval' => 5,
            'timezone' => 'Asia/Jakarta',
            'response_format' => 'json',
            'auto_acknowledge' => true,
            'retry_attempts' => 3,
            'retry_delay' => 60,
            'validation_rules' => json_encode([
                'order_id' => ['required' => true, 'type' => 'string'],
                'customer_name' => ['required' => true, 'type' => 'string'],
                'total_amount' => ['required' => true, 'type' => 'numeric']
            ])
        ]);
        
        echo "✅ Receiver baru berhasil dibuat!\n";
        echo "ID: {$receiver->id}\n";
        echo "Endpoint: https://copilotproduction.site/api/in/baden\n";
        echo "Username: {$receiver->auth_username}\n";
        echo "Password: {$receiver->auth_password}\n";
        echo "Basic Auth Header: Basic " . base64_encode('baden:baden') . "\n";
    }
    
    echo "\n🎉 Konfigurasi selesai! Sekarang Anda bisa menggunakan:\n";
    echo "URL: https://copilotproduction.site/api/in/baden\n";
    echo "Username: baden\n";
    echo "Password: baden\n";
    echo "Authorization Header: Basic YmFkZW46YmFkZW4=\n";
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
    echo "Stack trace:\n" . $e->getTraceAsString() . "\n";
}
