$server = 'copilotproduction.site'
$username = 'copg1493'
$password = 'wPD6DDSegDHd56'

$filesToUpload = @(
    @{
        local = 'import-api-data.php'
        remote = '/public_html/copilotproduction.site/import-api-data.php'
        description = 'Standalone import script'
    },
    @{
        local = 'resources/views/api-sources/index.blade.php'
        remote = '/public_html/copilotproduction.site/resources/views/api-sources/index.blade.php'
        description = 'Updated index view'
    },
    @{
        local = 'resources/views/api-sources/show.blade.php'
        remote = '/public_html/copilotproduction.site/resources/views/api-sources/show.blade.php'
        description = 'Updated show view'
    }
)

$successCount = 0
$errorCount = 0

foreach ($file in $filesToUpload) {
    try {
        Write-Host "Uploading $($file.description)..." -ForegroundColor Yellow
        
        # Create FTP request
        $ftpRequest = [System.Net.FtpWebRequest]::Create("ftp://$server$($file.remote)")
        $ftpRequest.Method = [System.Net.WebRequestMethods+Ftp]::UploadFile
        $ftpRequest.Credentials = New-Object System.Net.NetworkCredential($username, $password)
        $ftpRequest.UseBinary = $true
        $ftpRequest.UsePassive = $true

        # Upload file
        $fileContent = Get-Content -Path $file.local -Raw -Encoding UTF8
        $fileBytes = [System.Text.Encoding]::UTF8.GetBytes($fileContent)
        $ftpRequest.ContentLength = $fileBytes.Length
        $requestStream = $ftpRequest.GetRequestStream()
        $requestStream.Write($fileBytes, 0, $fileBytes.Length)
        $requestStream.Close()

        $response = $ftpRequest.GetResponse()
        Write-Host "✅ $($file.description) uploaded successfully" -ForegroundColor Green
        $response.Close()
        $successCount++
        
    } catch {
        Write-Host "❌ Failed to upload $($file.description): $($_.Exception.Message)" -ForegroundColor Red
        $errorCount++
    }
}

Write-Host ""
Write-Host "📊 Upload Summary:" -ForegroundColor Cyan
Write-Host "✅ Successful uploads: $successCount" -ForegroundColor Green
Write-Host "❌ Failed uploads: $errorCount" -ForegroundColor Red

if ($successCount -gt 0) {
    Write-Host ""
    Write-Host "🎯 SOLUTION DEPLOYED!" -ForegroundColor Green
    Write-Host "The import function now uses a standalone script that bypasses Laravel routing." -ForegroundColor White
    Write-Host ""
    Write-Host "Next steps:" -ForegroundColor Cyan
    Write-Host "1. Go to your API Sources page" -ForegroundColor White
    Write-Host "2. Click 'Import Data Now' button" -ForegroundColor White
    Write-Host "3. The import should now work without 404 errors" -ForegroundColor White
    Write-Host ""
    Write-Host "The standalone script directly accesses:" -ForegroundColor Yellow
    Write-Host "- Laravel models and database" -ForegroundColor White
    Write-Host "- HTTP client for API requests" -ForegroundColor White
    Write-Host "- Logging system for tracking" -ForegroundColor White
} 