Write-Host "=== UPLOAD PERUBAHAN KE HOSTING ===" -ForegroundColor Yellow
Write-Host "Server: copilotproduction.site" -ForegroundColor Cyan
Write-Host ""

$server = "copilotproduction.site"
$username = "copg1493"
$password = "wPD6DDSegDHd56"
$remotePath = "/public_html/copilotproduction.site"

# File yang perlu diupload (yang sudah dimodifikasi)
$filesToUpload = @(
    @{
        local = "resources/js/app.js"
        remote = "$remotePath/resources/js/app.js"
        description = "JavaScript dengan LoadingOverlay fix"
    },
    @{
        local = "resources/views/layouts/app.blade.php"
        remote = "$remotePath/resources/views/layouts/app.blade.php"
        description = "Layout dengan LoadingOverlay script"
    },
    @{
        local = "public/build/assets/app-CvHoO_cl.js"
        remote = "$remotePath/public/build/assets/app-CvHoO_cl.js"
        description = "Compiled JavaScript assets"
    },
    @{
        local = "public/build/assets/app-6n4EczMU.css"
        remote = "$remotePath/public/build/assets/app-6n4EczMU.css"
        description = "Compiled CSS assets"
    },
    @{
        local = "public/build/manifest.json"
        remote = "$remotePath/public/build/manifest.json"
        description = "Assets manifest"
    }
)

function Upload-File {
    param(
        [string]$LocalPath,
        [string]$RemotePath,
        [string]$Description
    )
    
    try {
        Write-Host "📤 Uploading: $Description" -ForegroundColor Cyan
        Write-Host "   Local: $LocalPath" -ForegroundColor Gray
        Write-Host "   Remote: $RemotePath" -ForegroundColor Gray
        
        # Check if local file exists
        if (-not (Test-Path $LocalPath)) {
            Write-Host "   ❌ Local file not found!" -ForegroundColor Red
            return $false
        }
        
        # Read file content
        $fileContent = [System.IO.File]::ReadAllBytes($LocalPath)
        
        # Create FTP request
        $ftpRequest = [System.Net.FtpWebRequest]::Create("ftp://$server$RemotePath")
        $ftpRequest.Credentials = New-Object System.Net.NetworkCredential($username, $password)
        $ftpRequest.Method = [System.Net.WebRequestMethods+Ftp]::UploadFile
        $ftpRequest.UsePassive = $true
        $ftpRequest.KeepAlive = $false
        $ftpRequest.ContentLength = $fileContent.Length
        
        # Upload file
        $requestStream = $ftpRequest.GetRequestStream()
        $requestStream.Write($fileContent, 0, $fileContent.Length)
        $requestStream.Close()
        
        # Get response
        $response = $ftpRequest.GetResponse()
        Write-Host "   ✅ Success: $($response.StatusDescription)" -ForegroundColor Green
        $response.Close()
        
        return $true
    }
    catch {
        Write-Host "   ❌ Error: $($_.Exception.Message)" -ForegroundColor Red
        return $false
    }
}

function Create-RemoteDirectory {
    param(
        [string]$RemoteDir
    )
    
    try {
        $ftpRequest = [System.Net.FtpWebRequest]::Create("ftp://$server$RemoteDir")
        $ftpRequest.Credentials = New-Object System.Net.NetworkCredential($username, $password)
        $ftpRequest.Method = [System.Net.WebRequestMethods+Ftp]::MakeDirectory
        $ftpRequest.UsePassive = $true
        
        $response = $ftpRequest.GetResponse()
        Write-Host "📁 Created directory: $RemoteDir" -ForegroundColor Green
        $response.Close()
        return $true
    }
    catch {
        # Directory might already exist, that's OK
        if ($_.Exception.Message -notmatch "550") {
            Write-Host "⚠️ Directory creation warning: $($_.Exception.Message)" -ForegroundColor Yellow
        }
        return $false
    }
}

# Test FTP connection first
Write-Host "🔗 Testing FTP connection..." -ForegroundColor Cyan
try {
    $testRequest = [System.Net.FtpWebRequest]::Create("ftp://$server/")
    $testRequest.Credentials = New-Object System.Net.NetworkCredential($username, $password)
    $testRequest.Method = [System.Net.WebRequestMethods+Ftp]::PrintWorkingDirectory
    $testRequest.UsePassive = $true
    
    $testResponse = $testRequest.GetResponse()
    Write-Host "✅ FTP connection successful!" -ForegroundColor Green
    $testResponse.Close()
}
catch {
    Write-Host "❌ FTP connection failed: $($_.Exception.Message)" -ForegroundColor Red
    exit 1
}

# Create necessary directories
Write-Host ""
Write-Host "📁 Creating remote directories..." -ForegroundColor Cyan
$directories = @(
    "$remotePath/resources",
    "$remotePath/resources/js",
    "$remotePath/resources/views",
    "$remotePath/resources/views/layouts",
    "$remotePath/public",
    "$remotePath/public/build",
    "$remotePath/public/build/assets"
)

foreach ($dir in $directories) {
    Create-RemoteDirectory -RemoteDir $dir
}

# Upload files
Write-Host ""
Write-Host "📤 Uploading modified files..." -ForegroundColor Cyan
$successCount = 0
$totalCount = $filesToUpload.Count

foreach ($file in $filesToUpload) {
    if (Upload-File -LocalPath $file.local -RemotePath $file.remote -Description $file.description) {
        $successCount++
    }
    Write-Host ""
}

# Summary
Write-Host "===========================================" -ForegroundColor Yellow
Write-Host "📊 Upload Summary:" -ForegroundColor Cyan
Write-Host "   Total files: $totalCount" -ForegroundColor White
Write-Host "   Successful: $successCount" -ForegroundColor Green
Write-Host "   Failed: $($totalCount - $successCount)" -ForegroundColor Red

if ($successCount -eq $totalCount) {
    Write-Host ""
    Write-Host "🎉 All files uploaded successfully!" -ForegroundColor Green
    Write-Host "✅ LoadingOverlay fix is now live on hosting!" -ForegroundColor Green
    Write-Host ""
    Write-Host "Next steps:" -ForegroundColor Cyan
    Write-Host "1. Clear browser cache (Ctrl+F5)" -ForegroundColor White
    Write-Host "2. Test import functionality on live site" -ForegroundColor White
    Write-Host "3. Verify no JavaScript errors in console" -ForegroundColor White
} else {
    Write-Host ""
    Write-Host "⚠️ Some files failed to upload. Please check the errors above." -ForegroundColor Yellow
}

Write-Host "===========================================" -ForegroundColor Yellow 