# License API Documentation

## Dashboard Features

### 🎯 Fitur-Fitur Dashboard yang Telah Diimplementasikan

#### 1. **Statistics Cards (Real-time Data)**
- **Total Licenses**: Menampilkan jumlah total license di sistem
- **Active Licenses**: Menampilkan jumlah license yang aktif
- **Expired Licenses**: Menampilkan jumlah license yang sudah expired
- **Monthly Revenue**: Kalkulasi pendapatan bulanan (estimasi $50/license)
- **Growth Indicators**: Persentase pertumbuhan dibanding bulan lalu

#### 2. **Interactive Charts**
- **License Activity Chart**: Grafik batang menampilkan aktivitas pembuatan license 7 hari terakhir
  - Hover untuk melihat detail jumlah license per hari
  - Data real-time dari database
  
- **Status Distribution**: Progress bar menampilkan distribusi status license
  - Active, Expired, Trial, Suspended
  - Persentase otomatis berdasarkan data real

#### 3. **Recent Licenses Table**
- Menampilkan 10 license terbaru
- Informasi lengkap:
  - License Key (sebagian ter-mask untuk keamanan)
  - Customer Name & Email
  - Product Name
  - Plan Type (Basic, Professional, Premium, Enterprise, Trial)
  - Status Badge (color-coded)
  - Expiry Date
  - Action buttons (Edit, View)

#### 4. **Responsive Sidebar Navigation**
- Dashboard (active)
- Licenses
- Customers
- Analytics
- Settings

#### 5. **Header Features**
- Search bar untuk pencarian license
- Notification bell dengan badge indicator
- User profile section
- Login/Register buttons

---

## API Endpoints

### 1. Dashboard (Web Route)

**Endpoint**: `GET /`  
**Description**: Menampilkan dashboard dengan data real dari database

**Response Data**:
```php
[
    'stats' => [
        'total' => int,      // Total licenses
        'active' => int,     // Active licenses
        'expired' => int,    // Expired licenses
        'suspended' => int,  // Suspended licenses
        'revenue' => int,    // Monthly revenue
    ],
    'growth' => [
        'total' => float,    // Growth percentage
        'active' => float,
        'expired' => float,
        'revenue' => float,
    ],
    'statusDistribution' => [
        'active' => float,   // Percentage
        'expired' => float,
        'trial' => float,
        'suspended' => float,
    ],
    'recentLicenses' => Collection,  // 10 recent licenses
    'chartData' => Array,            // 7 days chart data
]
```

---

### 2. License Verification (API)

**Endpoint**: `POST /api/license/check`  
**Description**: Memverifikasi license key untuk domain tertentu

**Request Body**:
```json
{
    "key": "XXXX-XXXX-XXXX-XXXX",
    "domain": "example.com"
}
```

**Success Response** (200):
```json
{
    "status": "valid",
    "msg": "License is valid",
    "data": {
        "license_key": "XXXX-XXXX-XXXX-XXXX",
        "domain": "example.com",
        "status": "active",
        "expired_at": "2025-12-31"
    }
}
```

**Error Responses**:
- `404`: License key not found
- `403`: License suspended, expired, or domain mismatch

---

### 3. License Activation (API)

**Endpoint**: `POST /api/license/activate`  
**Description**: Mengaktifkan license untuk domain tertentu

**Request Body**:
```json
{
    "key": "XXXX-XXXX-XXXX-XXXX",
    "domain": "example.com"
}
```

**Success Response** (200):
```json
{
    "status": "activated",
    "msg": "License activated successfully",
    "data": {
        "license_key": "XXXX-XXXX-XXXX-XXXX",
        "domain": "example.com",
        "status": "active",
        "activated_at": "2024-11-23 12:00:00"
    }
}
```

**Error Responses**:
- `404`: License key not found
- `400`: License already assigned to another domain

---

## Database Schema

### Licenses Table

```sql
CREATE TABLE licenses (
    id BIGINT UNSIGNED PRIMARY KEY AUTO_INCREMENT,
    license_key VARCHAR(255) UNIQUE NOT NULL,
    customer_name VARCHAR(255) NOT NULL,
    customer_email VARCHAR(255) NOT NULL,
    product_name VARCHAR(255) NOT NULL,
    plan_type ENUM('basic', 'professional', 'premium', 'enterprise', 'trial') DEFAULT 'basic',
    domain VARCHAR(255) NULLABLE,
    ip_address VARCHAR(255) NULLABLE,
    status ENUM('active', 'inactive', 'suspended') DEFAULT 'inactive',
    expired_at DATE NULLABLE,
    created_at TIMESTAMP,
    updated_at TIMESTAMP
);
```

---

## Installation & Setup

### 1. Install Dependencies
```bash
composer install
```

### 2. Configure Environment
```bash
cp .env.example .env
php artisan key:generate
```

### 3. Run Migrations
```bash
php artisan migrate
```

### 4. Seed Sample Data
```bash
php artisan db:seed --class=LicenseSeeder
```

This will generate 50 sample licenses with:
- Various customer names and emails
- Different product names
- Mixed plan types (basic, professional, premium, enterprise, trial)
- Random status (active, inactive, suspended)
- Different expiry dates
- Creation dates spread over 90 days

### 5. Start Server
```bash
php artisan serve
```

Visit: `http://127.0.0.1:8000`

---

## Generate New License Keys

Use the Artisan command:

```bash
php artisan generate:license

# Generate multiple licenses
php artisan generate:license 5
```

---

## Technology Stack

- **Backend**: Laravel 11
- **Database**: SQLite (configurable to MySQL/PostgreSQL)
- **Frontend**: Blade Templates + Tailwind CSS
- **Icons**: Heroicons
- **Fonts**: Inter (via Bunny Fonts)

---

## Features Highlight

✅ **Real-time Data**: Semua data diambil dari database, bukan dummy data  
✅ **Responsive Design**: Mobile-friendly dashboard  
✅ **Interactive Charts**: Hover effects dan tooltips  
✅ **Color-coded Status**: Visual indicators untuk status license  
✅ **Growth Metrics**: Perbandingan dengan bulan sebelumnya  
✅ **Security**: License key ter-mask di tampilan tabel  
✅ **RESTful API**: Endpoints untuk verifikasi dan aktivasi license  

---

## Security Considerations

1. **License Key Masking**: Di dashboard, license key sebagian di-mask untuk keamanan
2. **IP Tracking**: Sistem mencatat IP address saat aktivasi
3. **Domain Validation**: Verifikasi domain saat check license
4. **Status Management**: Sistem kontrol untuk suspend/activate license

---

## Future Enhancements (Recommendations)

1. **Authentication**: Implement Laravel Breeze/Jetstream
2. **License Management CRUD**: Full create, read, update, delete operations
3. **Customer Management**: Dedicated customer management module
4. **Email Notifications**: Auto-send license keys dan expiry reminders
5. **Advanced Analytics**: More detailed charts dan reports
6. **Export Features**: Export licenses ke CSV/PDF
7. **Bulk Operations**: Mass activate/suspend licenses
8. **API Rate Limiting**: Protect endpoints from abuse
9. **Webhook Support**: Notify external systems on license events
10. **Multi-tenancy**: Support untuk multiple organizations

---

## Support

Untuk pertanyaan atau issue, silakan hubungi tim development.

**Version**: 1.0.0  
**Last Updated**: November 23, 2024

