# 📐 SYSTEM ARCHITECTURE DIAGRAM

## 🏗️ **OVERVIEW**

```
┌───────────────────────────────────────────────────────────────────────────┐
│                        LICENSE API SYSTEM                                 │
│                                                                           │
│  ┌──────────────────┐          ┌──────────────────┐                     │
│  │   ADMIN PANEL    │          │   API SERVER     │                     │
│  │                  │          │                  │                     │
│  │  • Dashboard     │          │  POST /activate  │                     │
│  │  • Licenses CRUD │◄────────►│  GET  /verify    │                     │
│  │  • Customers     │          │                  │                     │
│  │  • Analytics     │          │  [Laravel 12]    │                     │
│  │  • Settings      │          │  [SQLite DB]     │                     │
│  └──────────────────┘          └────────┬─────────┘                     │
│         ▲                               │                                │
│         │                               │                                │
│         │     http://127.0.0.1:8000     │                                │
│         │                               │                                │
└─────────┼───────────────────────────────┼────────────────────────────────┘
          │                               │
          │                               │ API Calls
          │                               ▼
┌─────────┴─────────────────────────────────────────────────────────────────┐
│                         CLIENT WEBSITES                                   │
│                                                                           │
│  ┌─────────────────────────────────────────────────────────────────┐    │
│  │  Customer Website 1: example.com                                 │    │
│  │  ┌──────────────────┐    ┌──────────────────┐                   │    │
│  │  │ activate.php     │───►│ LicenseValidator │───► API Server    │    │
│  │  │ (One-time setup) │    │ .php             │                   │    │
│  │  └──────────────────┘    └──────────────────┘                   │    │
│  │                                    │                              │    │
│  │                                    │                              │    │
│  │                                    ▼                              │    │
│  │  ┌──────────────────┐    ┌──────────────────┐                   │    │
│  │  │ index.php        │───►│ license.json     │                   │    │
│  │  │ (Protected)      │    │ (Local cache)    │                   │    │
│  │  └──────────────────┘    └──────────────────┘                   │    │
│  └─────────────────────────────────────────────────────────────────┘    │
│                                                                           │
│  ┌─────────────────────────────────────────────────────────────────┐    │
│  │  Customer Website 2: testdomain.com                              │    │
│  │  [Same structure...]                                             │    │
│  └─────────────────────────────────────────────────────────────────┘    │
│                                                                           │
└───────────────────────────────────────────────────────────────────────────┘
```

---

## 🔄 **ACTIVATION FLOW**

```
┌──────────────┐
│  1. CREATE   │  Admin creates license via dashboard
│   LICENSE    │  → License Key: XXXX-XXXX-XXXX-XXXX
└──────┬───────┘  → Status: inactive
       │          → Domain: null
       ▼
┌──────────────┐
│  2. SEND TO  │  Admin gives license key to customer
│   CUSTOMER   │  (Email, SMS, or manual)
└──────┬───────┘
       │
       ▼
┌──────────────┐
│  3. CUSTOMER │  Customer opens: customersite.com/activate.php
│   ACTIVATES  │  → Inputs license key
└──────┬───────┘  → Domain auto-detected
       │
       ▼
┌──────────────┐
│  4. API CALL │  POST /api/activate
│   ACTIVATE   │  {
└──────┬───────┘    "key": "XXXX-XXXX-XXXX-XXXX",
       │            "domain": "customersite.com"
       ▼          }
┌──────────────┐
│  5. SERVER   │  • Check if license exists
│   VALIDATES  │  • Check if not already assigned
└──────┬───────┘  • Check status & expiry
       │
       ▼
┌──────────────┐
│  6. ASSIGN   │  Update database:
│   DOMAIN     │  → domain = "customersite.com"
└──────┬───────┘  → status = "active"
       │          → ip_address = customer's IP
       ▼
┌──────────────┐
│  7. SAVE     │  Save to license.json:
│   LOCAL      │  {
└──────┬───────┘    "key": "XXXX...",
       │            "domain": "customersite.com",
       ▼            "activated_at": "2024-11-23 12:00:00"
┌──────────────┐  }
│  8. SUCCESS  │
│   REDIRECT   │  → Redirect to index.php (dashboard)
└──────────────┘
```

---

## 🔍 **VERIFICATION FLOW**

```
┌────────────────┐
│ Customer loads │  User accesses protected page
│ protected page │  Example: customersite.com/index.php
└────────┬───────┘
         │
         ▼
┌────────────────┐
│ Check license  │  LicenseValidator->verify()
│ .json exists?  │
└────┬──────┬────┘
     │ NO   │ YES
     ▼      ▼
  ┌─────┐ ┌────────────────┐
  │ERROR│ │ Check last_    │  Was verified < 5 minutes ago?
  └─────┘ │ check time     │
          └────┬──────┬────┘
               │ YES  │ NO
               ▼      ▼
          ┌─────┐ ┌────────────────┐
          │ALLOW│ │ API CALL       │  GET /api/verify
          │(skip│ │                │  ?key=XXX&domain=YYY
          │ API)│ └────────┬───────┘
          └─────┘          │
                           ▼
                  ┌────────────────┐
                  │ SERVER CHECK   │  • License exists?
                  │                │  • Domain match?
                  └────────┬───────┘  • Status active?
                           │          • Not expired?
                           │
                  ┌────────┴────────┐
                  │                 │
            VALID │                 │ INVALID
                  ▼                 ▼
          ┌────────────┐     ┌────────────┐
          │ UPDATE     │     │ REDIRECT   │
          │ last_check │     │ TO         │
          │ timestamp  │     │ activate   │
          └──────┬─────┘     │ .php       │
                 │           └────────────┘
                 ▼
          ┌────────────┐
          │ ALLOW      │
          │ ACCESS     │
          └────────────┘
```

---

## 🗄️ **DATABASE STRUCTURE**

```
┌─────────────────────────────────────────────────────────────┐
│                      LICENSES TABLE                         │
├──────────────┬─────────────┬──────────────────────────────┤
│ Column       │ Type        │ Description                  │
├──────────────┼─────────────┼──────────────────────────────┤
│ id           │ integer     │ Primary Key (Auto)           │
│ license_key  │ string      │ XXXX-XXXX-XXXX-XXXX (Unique) │
│ customer_name│ string      │ "John Doe"                   │
│ customer_    │ string      │ "john@example.com"           │
│   email      │             │                              │
│ product_name │ string      │ "Premium Plugin"             │
│ plan_type    │ enum        │ basic|professional|premium|  │
│              │             │ enterprise|trial             │
│ domain       │ string|null │ "example.com" (after active) │
│ ip_address   │ string|null │ "192.168.1.1"                │
│ status       │ enum        │ active|inactive|suspended    │
│ expired_at   │ date|null   │ "2025-12-31"                 │
│ created_at   │ timestamp   │ Auto                         │
│ updated_at   │ timestamp   │ Auto                         │
└──────────────┴─────────────┴──────────────────────────────┘

Example Row:
┌────┬──────────────────────┬──────────────┬────────────────┐
│ id │ license_key          │ customer_name│ domain         │
├────┼──────────────────────┼──────────────┼────────────────┤
│ 1  │ ZKZ7-TVOJ-6OAY-KR34  │ Carol Davis  │ example.com    │
│ 2  │ AB12-CD34-EF56-GH78  │ John Smith   │ NULL (inactive)│
│ 3  │ WX90-YZ12-AB34-CD56  │ Jane Doe     │ testsite.com   │
└────┴──────────────────────┴──────────────┴────────────────┘
```

---

## 📊 **DATA FLOW DIAGRAM**

```
                    ┌─────────────────┐
                    │   ADMIN PANEL   │
                    │  (Web Browser)  │
                    └────────┬────────┘
                             │
                   HTTP GET/POST (Web Routes)
                             │
                             ▼
        ┌────────────────────────────────────────┐
        │         WEB CONTROLLERS                │
        │                                        │
        │ • DashboardController                  │
        │ • LicenseCrudController                │
        │ • CustomerController                   │
        │ • AnalyticsController                  │
        │ • SettingsController                   │
        └────────────┬───────────────────────────┘
                     │
                     │ Eloquent ORM
                     ▼
        ┌────────────────────────────────────────┐
        │         LICENSE MODEL                  │
        │         (App\Models\License)           │
        └────────────┬───────────────────────────┘
                     │
                     │ SQL Queries
                     ▼
        ┌────────────────────────────────────────┐
        │        SQLite DATABASE                 │
        │      (database/database.sqlite)        │
        └────────────────────────────────────────┘
                     ▲
                     │ SQL Queries
                     │
        ┌────────────┴───────────────────────────┐
        │         LICENSE MODEL                  │
        └────────────┬───────────────────────────┘
                     │
                     │ Eloquent ORM
                     ▼
        ┌────────────────────────────────────────┐
        │         API CONTROLLER                 │
        │      (LicenseController)               │
        │                                        │
        │ • activate() - POST /api/activate      │
        │ • check() - GET /api/verify            │
        └────────────┬───────────────────────────┘
                     │
             HTTP JSON Response
                     │
                     ▼
        ┌────────────────────────────────────────┐
        │       CLIENT WEBSITES                  │
        │    (LicenseValidator.php)              │
        └────────────────────────────────────────┘
```

---

## 🌐 **NETWORK DIAGRAM**

```
Internet
    │
    │ HTTPS (Production) / HTTP (Development)
    │
    ├─────────────┬─────────────┬─────────────┐
    │             │             │             │
    ▼             ▼             ▼             ▼
┌────────┐  ┌────────┐  ┌────────┐  ┌────────┐
│Customer│  │Customer│  │Customer│  │ Admin  │
│Site 1  │  │Site 2  │  │Site 3  │  │Browser │
└───┬────┘  └───┬────┘  └───┬────┘  └───┬────┘
    │           │           │           │
    │ API       │ API       │ API       │ Web
    │ Calls     │ Calls     │ Calls     │ Access
    │           │           │           │
    └───────────┴───────────┴───────────┘
                    │
                    ▼
        ┌───────────────────────┐
        │  LICENSE API SERVER   │
        │  127.0.0.1:8000       │
        │                       │
        │  ┌─────────────────┐ │
        │  │ Laravel App     │ │
        │  │ • Routes        │ │
        │  │ • Controllers   │ │
        │  │ • Middleware    │ │
        │  │ • Validation    │ │
        │  └────────┬────────┘ │
        │           │           │
        │  ┌────────▼────────┐ │
        │  │ SQLite Database │ │
        │  │ 50 Licenses     │ │
        │  └─────────────────┘ │
        └───────────────────────┘
```

---

## 📂 **FILE ORGANIZATION**

```
lisensiapi/
│
├── app/
│   ├── Http/
│   │   └── Controllers/
│   │       ├── DashboardController.php       ← Dashboard stats
│   │       ├── LicenseCrudController.php     ← License management
│   │       ├── CustomerController.php        ← Customer management
│   │       ├── AnalyticsController.php       ← Analytics data
│   │       ├── SettingsController.php        ← System settings
│   │       └── LicenseController.php         ← API endpoints
│   └── Models/
│       └── License.php                       ← Database model
│
├── database/
│   ├── migrations/
│   │   ├── create_licenses_table.php         ← Schema
│   │   └── add_customer_info.php             ← Additional fields
│   ├── seeders/
│   │   └── LicenseSeeder.php                 ← 50 sample data
│   └── database.sqlite                       ← SQLite file
│
├── resources/
│   └── views/
│       ├── layouts/
│       │   └── app.blade.php                 ← Shared layout
│       ├── welcome.blade.php                 ← Dashboard
│       ├── licenses/                         ← License views
│       ├── customers/                        ← Customer views
│       ├── analytics/                        ← Analytics views
│       └── settings/                         ← Settings views
│
├── routes/
│   ├── web.php                               ← Web routes (19)
│   └── api.php                               ← API routes (2)
│
├── client-example/                           ← CLIENT INTEGRATION
│   ├── LicenseValidator.php                  ← Helper class
│   ├── activate.php                          ← Activation page
│   ├── index.php                             ← Protected page
│   ├── deactivate.php                        ← Deactivate
│   ├── test-api.php                          ← API tester
│   ├── .htaccess                             ← Security
│   └── README.md                             ← Client docs
│
└── Documentation/
    ├── README.md                             ← Main readme
    ├── QUICK_START.md                        ← Quick guide
    ├── FINAL_SUMMARY.md                      ← Complete overview
    ├── SYSTEM_DIAGRAM.md                     ← This file
    ├── API_DOCUMENTATION.md                  ← API reference
    ├── FEATURES_DOCUMENTATION.md             ← Features guide
    └── CLIENT_INTEGRATION_GUIDE.md           ← Integration manual
```

---

## 🔐 **SECURITY LAYERS**

```
┌────────────────────────────────────────────────────┐
│           CLIENT REQUEST                           │
└─────────────────┬──────────────────────────────────┘
                  │
                  ▼
         ┌────────────────┐
         │ 1. HTTPS/TLS   │  Encrypted transport
         └────────┬───────┘
                  │
                  ▼
         ┌────────────────┐
         │ 2. Rate Limit  │  60 req/min per IP
         └────────┬───────┘
                  │
                  ▼
         ┌────────────────┐
         │ 3. Input       │  Validate all inputs
         │    Validation  │
         └────────┬───────┘
                  │
                  ▼
         ┌────────────────┐
         │ 4. License     │  • Exists?
         │    Check       │  • Status active?
         └────────┬───────┘  • Not expired?
                  │          • Domain match?
                  ▼
         ┌────────────────┐
         │ 5. Domain      │  Verify domain ownership
         │    Validation  │
         └────────┬───────┘
                  │
                  ▼
         ┌────────────────┐
         │ 6. Response    │  JSON with status
         └────────────────┘
```

---

## 📈 **SCALING STRATEGY**

```
Current Setup (Development):
┌──────────────────────────┐
│ Single Server            │
│ • Laravel App            │
│ • SQLite Database        │
│ • 50 licenses max        │
└──────────────────────────┘

Production Setup (Small):
┌──────────────────────────┐
│ Single VPS               │
│ • Laravel App            │
│ • MySQL Database         │
│ • 10K+ licenses          │
│ • Nginx + PHP-FPM        │
└──────────────────────────┘

Production Setup (Large):
┌──────────────────────────┐
│ Load Balancer            │
└───────────┬──────────────┘
            │
    ┌───────┴───────┐
    │               │
┌───▼────┐      ┌───▼────┐
│App     │      │App     │
│Server 1│      │Server 2│
└───┬────┘      └───┬────┘
    │               │
    └───────┬───────┘
            │
    ┌───────▼────────┐
    │ Redis Cache    │
    └───────┬────────┘
            │
    ┌───────▼────────┐
    │ MySQL Cluster  │
    │ (Master-Slave) │
    └────────────────┘
```

---

## ✅ **CONCLUSION**

Sistem License API ini dirancang dengan:

✅ **Modular Architecture** - Easy to extend  
✅ **Clean Code** - Follow Laravel best practices  
✅ **Secure** - Multiple security layers  
✅ **Scalable** - Ready for production  
✅ **Well Documented** - Complete guides  

**Ready to use! 🚀**

