<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class SettingsController extends Controller
{
    public function index()
    {
        // In a real application, these would come from database or config files
        $settings = [
            'app_name' => config('app.name'),
            'app_url' => config('app.url'),
            'timezone' => config('app.timezone'),
            'locale' => config('app.locale'),
            'debug_mode' => config('app.debug'),
        ];

        return view('settings.index', compact('settings'));
    }

    public function update(Request $request)
    {
        // In a real application, you would save these to database or update config files
        // For now, we'll just show a success message
        
        return redirect()->route('settings.index')
            ->with('success', 'Settings updated successfully! (Note: This is a demo - changes are not persisted)');
    }
}
