<?php
/**
 * Halaman Aktivasi License
 * 
 * Halaman ini digunakan untuk mengaktifkan license pertama kali
 */

require_once 'LicenseValidator.php';

$licenseValidator = new LicenseValidator();
$message = '';
$success = false;
$error = '';

// Check if already activated
$existingLicense = $licenseValidator->getLicenseInfo();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $licenseKey = trim($_POST['license_key'] ?? '');
    $domain = trim($_POST['domain'] ?? $_SERVER['HTTP_HOST']);
    
    if (empty($licenseKey)) {
        $error = 'License key tidak boleh kosong!';
    } else {
        $result = $licenseValidator->activate($licenseKey, $domain);
        $message = $result['message'];
        $success = $result['success'];
        
        if ($success) {
            // Redirect ke index setelah 2 detik
            header('Refresh: 2; URL=index.php');
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Aktivasi License</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gradient-to-br from-indigo-100 via-purple-50 to-pink-100 min-h-screen flex items-center justify-center p-4">
    <div class="bg-white rounded-2xl shadow-2xl max-w-md w-full overflow-hidden">
        <!-- Header -->
        <div class="bg-gradient-to-r from-indigo-600 to-purple-600 p-6 text-center">
            <svg class="w-16 h-16 mx-auto mb-3 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 7a2 2 0 012 2m4 0a6 6 0 01-7.743 5.743L11 17H9v2H7v2H4a1 1 0 01-1-1v-2.586a1 1 0 01.293-.707l5.964-5.964A6 6 0 1121 9z" />
            </svg>
            <h1 class="text-2xl font-bold text-white">Aktivasi License</h1>
            <p class="text-indigo-100 text-sm mt-2">Masukkan license key Anda</p>
        </div>
        
        <!-- Body -->
        <div class="p-6">
            <?php if ($existingLicense): ?>
            <div class="mb-4 p-4 rounded-lg bg-yellow-50 border border-yellow-200">
                <div class="flex items-start">
                    <svg class="w-5 h-5 text-yellow-600 mt-0.5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z" />
                    </svg>
                    <div>
                        <p class="text-sm font-semibold text-yellow-800">License Sudah Aktif!</p>
                        <p class="text-xs text-yellow-700 mt-1">
                            Domain: <?= htmlspecialchars($existingLicense['domain']) ?><br>
                            Activated: <?= htmlspecialchars($existingLicense['activated_at']) ?>
                        </p>
                    </div>
                </div>
                <a href="index.php" class="mt-3 block text-center text-sm text-yellow-700 hover:text-yellow-900 font-medium">
                    → Ke Dashboard
                </a>
            </div>
            <?php endif; ?>
            
            <?php if ($message): ?>
            <div class="mb-4 p-4 rounded-lg <?= $success ? 'bg-green-50 border border-green-200' : 'bg-red-50 border border-red-200' ?>">
                <div class="flex items-start">
                    <?php if ($success): ?>
                    <svg class="w-5 h-5 text-green-600 mt-0.5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                    </svg>
                    <?php else: ?>
                    <svg class="w-5 h-5 text-red-600 mt-0.5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                    </svg>
                    <?php endif; ?>
                    <p class="text-sm <?= $success ? 'text-green-800' : 'text-red-800' ?>">
                        <?= htmlspecialchars($message) ?>
                    </p>
                </div>
                <?php if ($success): ?>
                <p class="text-xs text-green-600 mt-2 ml-7">Redirecting ke dashboard...</p>
                <?php endif; ?>
            </div>
            <?php endif; ?>
            
            <?php if ($error): ?>
            <div class="mb-4 p-4 rounded-lg bg-red-50 border border-red-200">
                <p class="text-sm text-red-800"><?= htmlspecialchars($error) ?></p>
            </div>
            <?php endif; ?>
            
            <form method="POST" action="" class="space-y-4">
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-2">
                        License Key <span class="text-red-500">*</span>
                    </label>
                    <input 
                        type="text" 
                        name="license_key" 
                        required 
                        placeholder="XXXX-XXXX-XXXX-XXXX"
                        pattern="[A-Za-z0-9]{4}-[A-Za-z0-9]{4}-[A-Za-z0-9]{4}-[A-Za-z0-9]{4}"
                        class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 font-mono text-center text-lg"
                        value="<?= htmlspecialchars($_POST['license_key'] ?? '') ?>">
                    <p class="text-xs text-gray-500 mt-1">Format: XXXX-XXXX-XXXX-XXXX</p>
                </div>
                
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-2">
                        Domain <span class="text-red-500">*</span>
                    </label>
                    <input 
                        type="text" 
                        name="domain" 
                        value="<?= htmlspecialchars($_SERVER['HTTP_HOST']) ?>" 
                        required
                        readonly
                        class="w-full px-4 py-3 border border-gray-300 rounded-lg bg-gray-50 text-gray-600">
                    <p class="text-xs text-gray-500 mt-1">Domain terdeteksi otomatis</p>
                </div>
                
                <button 
                    type="submit" 
                    class="w-full bg-gradient-to-r from-indigo-600 to-purple-600 text-white py-3 px-4 rounded-lg hover:from-indigo-700 hover:to-purple-700 font-semibold shadow-lg hover:shadow-xl transition-all duration-200 transform hover:-translate-y-0.5">
                    🔑 Aktivasi License
                </button>
            </form>
            
            <div class="mt-6 pt-6 border-t border-gray-200">
                <p class="text-xs text-gray-500 text-center">
                    Belum punya license?
                    <a href="http://127.0.0.1:8000/" target="_blank" class="text-indigo-600 hover:text-indigo-800 font-medium">
                        Hubungi Admin →
                    </a>
                </p>
            </div>
        </div>
    </div>
</body>
</html>

