<?php
/**
 * Deactivate License
 */

require_once 'LicenseValidator.php';

$licenseValidator = new LicenseValidator();
$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['confirm'])) {
    $licenseValidator->deactivate();
    header('Location: activate.php');
    exit;
}

$licenseInfo = $licenseValidator->getLicenseInfo();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Deactivate License</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 min-h-screen flex items-center justify-center p-4">
    <div class="bg-white rounded-2xl shadow-2xl max-w-md w-full p-8">
        <div class="text-center mb-6">
            <div class="w-16 h-16 bg-red-100 rounded-full flex items-center justify-center mx-auto mb-4">
                <svg class="w-8 h-8 text-red-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z" />
                </svg>
            </div>
            <h1 class="text-2xl font-bold text-gray-900 mb-2">Deactivate License?</h1>
            <p class="text-sm text-gray-600">Apakah Anda yakin ingin menonaktifkan license?</p>
        </div>
        
        <?php if ($licenseInfo): ?>
        <div class="bg-gray-50 rounded-lg p-4 mb-6">
            <p class="text-xs text-gray-500 mb-2">Current License:</p>
            <p class="font-mono text-sm font-bold text-gray-900 mb-1"><?= htmlspecialchars($licenseInfo['key']) ?></p>
            <p class="text-xs text-gray-600">Domain: <?= htmlspecialchars($licenseInfo['domain']) ?></p>
        </div>
        
        <div class="bg-yellow-50 border border-yellow-200 rounded-lg p-4 mb-6">
            <p class="text-sm text-yellow-800">
                <strong>Peringatan:</strong> Setelah deactivate, Anda perlu mengaktifkan ulang license untuk mengakses aplikasi ini.
            </p>
        </div>
        
        <form method="POST" action="">
            <input type="hidden" name="confirm" value="1">
            <div class="flex gap-3">
                <a href="index.php" class="flex-1 text-center px-4 py-3 border border-gray-300 rounded-lg text-gray-700 font-semibold hover:bg-gray-50 transition-colors">
                    Cancel
                </a>
                <button type="submit" class="flex-1 bg-red-600 text-white px-4 py-3 rounded-lg font-semibold hover:bg-red-700 transition-colors">
                    Yes, Deactivate
                </button>
            </div>
        </form>
        <?php else: ?>
        <div class="text-center">
            <p class="text-gray-600 mb-4">Tidak ada license yang aktif.</p>
            <a href="activate.php" class="inline-block bg-indigo-600 text-white px-6 py-3 rounded-lg font-semibold hover:bg-indigo-700 transition-colors">
                Activate License
            </a>
        </div>
        <?php endif; ?>
    </div>
</body>
</html>

