<?php
/**
 * Protected Page - Hanya bisa diakses dengan license valid
 */

require_once 'LicenseValidator.php';

$licenseValidator = new LicenseValidator();
$licenseCheck = $licenseValidator->verify();

// Redirect ke activate jika license tidak valid
if (!$licenseCheck['valid']) {
    header('Location: activate.php');
    exit;
}

$licenseInfo = $licenseValidator->getLicenseInfo();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - Protected Area</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-50 min-h-screen">
    <!-- Header -->
    <header class="bg-white shadow-sm border-b border-gray-200">
        <div class="container mx-auto px-4 py-4">
            <div class="flex items-center justify-between">
                <div class="flex items-center gap-3">
                    <div class="w-10 h-10 bg-gradient-to-r from-indigo-600 to-purple-600 rounded-lg flex items-center justify-center">
                        <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 7a2 2 0 012 2m4 0a6 6 0 01-7.743 5.743L11 17H9v2H7v2H4a1 1 0 01-1-1v-2.586a1 1 0 01.293-.707l5.964-5.964A6 6 0 1121 9z" />
                        </svg>
                    </div>
                    <div>
                        <h1 class="text-xl font-bold text-gray-900">My Premium App</h1>
                        <p class="text-xs text-gray-500">Protected by License API</p>
                    </div>
                </div>
                
                <div class="flex items-center gap-4">
                    <span class="px-3 py-1.5 bg-green-100 text-green-800 rounded-full text-xs font-semibold flex items-center gap-1">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                        </svg>
                        License Valid
                    </span>
                    <a href="deactivate.php" class="text-sm text-gray-600 hover:text-gray-900">Deactivate</a>
                </div>
            </div>
        </div>
    </header>
    
    <!-- Main Content -->
    <main class="container mx-auto px-4 py-8">
        <!-- License Info Card -->
        <div class="mb-8 bg-gradient-to-r from-indigo-600 to-purple-600 rounded-2xl shadow-xl p-8 text-white">
            <div class="flex items-center justify-between">
                <div>
                    <h2 class="text-2xl font-bold mb-2">🎉 Welcome to Premium Area!</h2>
                    <p class="text-indigo-100">Your license is active and verified</p>
                </div>
                <svg class="w-20 h-20 opacity-20" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0121 12c0 5.523-4.477 10-10 10S1 17.523 1 12 5.477 2 11 2c2.152 0 4.164.616 5.858 1.678" />
                </svg>
            </div>
            
            <div class="mt-6 grid grid-cols-1 md:grid-cols-3 gap-4">
                <div class="bg-white/10 backdrop-blur-sm rounded-lg p-4">
                    <p class="text-indigo-200 text-xs font-medium mb-1">License Key</p>
                    <p class="font-mono text-sm"><?= htmlspecialchars($licenseInfo['key'] ?? 'N/A') ?></p>
                </div>
                <div class="bg-white/10 backdrop-blur-sm rounded-lg p-4">
                    <p class="text-indigo-200 text-xs font-medium mb-1">Domain</p>
                    <p class="text-sm"><?= htmlspecialchars($licenseInfo['domain'] ?? 'N/A') ?></p>
                </div>
                <div class="bg-white/10 backdrop-blur-sm rounded-lg p-4">
                    <p class="text-indigo-200 text-xs font-medium mb-1">Expires At</p>
                    <p class="text-sm"><?= htmlspecialchars($licenseCheck['expires_at'] ?? 'N/A') ?></p>
                </div>
            </div>
        </div>
        
        <!-- Feature Cards -->
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8">
            <div class="bg-white rounded-xl shadow-sm p-6 border border-gray-200 hover:shadow-md transition-shadow">
                <div class="w-12 h-12 bg-blue-100 rounded-lg flex items-center justify-center mb-4">
                    <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z" />
                    </svg>
                </div>
                <h3 class="text-lg font-bold text-gray-900 mb-2">Premium Feature 1</h3>
                <p class="text-sm text-gray-600">Akses ke fitur premium yang hanya tersedia untuk license holder.</p>
            </div>
            
            <div class="bg-white rounded-xl shadow-sm p-6 border border-gray-200 hover:shadow-md transition-shadow">
                <div class="w-12 h-12 bg-green-100 rounded-lg flex items-center justify-center mb-4">
                    <svg class="w-6 h-6 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6V4m0 2a2 2 0 100 4m0-4a2 2 0 110 4m-6 8a2 2 0 100-4m0 4a2 2 0 110-4m0 4v2m0-6V4m6 6v10m6-2a2 2 0 100-4m0 4a2 2 0 110-4m0 4v2m0-6V4" />
                    </svg>
                </div>
                <h3 class="text-lg font-bold text-gray-900 mb-2">Advanced Tools</h3>
                <p class="text-sm text-gray-600">Tools canggih untuk meningkatkan produktivitas Anda.</p>
            </div>
            
            <div class="bg-white rounded-xl shadow-sm p-6 border border-gray-200 hover:shadow-md transition-shadow">
                <div class="w-12 h-12 bg-purple-100 rounded-lg flex items-center justify-center mb-4">
                    <svg class="w-6 h-6 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0121 12c0 5.523-4.477 10-10 10S1 17.523 1 12 5.477 2 11 2c2.152 0 4.164.616 5.858 1.678" />
                    </svg>
                </div>
                <h3 class="text-lg font-bold text-gray-900 mb-2">Priority Support</h3>
                <p class="text-sm text-gray-600">Dapatkan dukungan prioritas dari tim kami 24/7.</p>
            </div>
        </div>
        
        <!-- Content Area -->
        <div class="bg-white rounded-xl shadow-sm p-8 border border-gray-200">
            <h2 class="text-2xl font-bold text-gray-900 mb-4">Premium Content</h2>
            <div class="prose max-w-none">
                <p class="text-gray-600 mb-4">
                    Selamat datang di area premium! Halaman ini dilindungi oleh sistem License API dan hanya bisa diakses oleh pengguna dengan license yang valid.
                </p>
                
                <div class="bg-blue-50 border border-blue-200 rounded-lg p-4 mb-4">
                    <h3 class="text-lg font-semibold text-blue-900 mb-2">✨ Keuntungan Premium:</h3>
                    <ul class="list-disc list-inside text-sm text-blue-800 space-y-1">
                        <li>Akses unlimited ke semua fitur</li>
                        <li>Support 24/7 dari tim expert</li>
                        <li>Update gratis selamanya</li>
                        <li>Priority bug fixes</li>
                        <li>Custom integration support</li>
                    </ul>
                </div>
                
                <p class="text-gray-600">
                    License Anda akan otomatis diverifikasi setiap kali Anda mengakses halaman. Sistem menggunakan caching untuk mengurangi API calls, sehingga performa tetap optimal.
                </p>
            </div>
        </div>
        
        <!-- License Status -->
        <div class="mt-6 bg-gray-100 rounded-xl p-6">
            <h3 class="text-sm font-semibold text-gray-700 mb-3">License Status:</h3>
            <div class="grid grid-cols-2 md:grid-cols-4 gap-4 text-center">
                <div>
                    <p class="text-2xl font-bold text-green-600">✓</p>
                    <p class="text-xs text-gray-600 mt-1">Verified</p>
                </div>
                <div>
                    <p class="text-2xl font-bold text-green-600">✓</p>
                    <p class="text-xs text-gray-600 mt-1">Active</p>
                </div>
                <div>
                    <p class="text-2xl font-bold text-green-600">✓</p>
                    <p class="text-xs text-gray-600 mt-1">Valid Domain</p>
                </div>
                <div>
                    <p class="text-2xl font-bold text-green-600">✓</p>
                    <p class="text-xs text-gray-600 mt-1">Not Expired</p>
                </div>
            </div>
        </div>
    </main>
    
    <!-- Footer -->
    <footer class="container mx-auto px-4 py-6 mt-12 border-t border-gray-200">
        <p class="text-center text-sm text-gray-500">
            Protected by <a href="http://127.0.0.1:8000/" target="_blank" class="text-indigo-600 hover:text-indigo-800 font-medium">License API System</a>
            • Last checked: <?= date('Y-m-d H:i:s') ?>
            <?= isset($licenseCheck['cached']) && $licenseCheck['cached'] ? ' (cached)' : '' ?>
        </p>
    </footer>
</body>
</html>

