<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>API Tester</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 p-8">
    <div class="max-w-4xl mx-auto">
        <h1 class="text-3xl font-bold text-gray-900 mb-8">🧪 License API Tester</h1>
        
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <!-- Test Activate -->
            <div class="bg-white rounded-xl shadow-sm p-6 border border-gray-200">
                <h2 class="text-lg font-bold text-gray-900 mb-4">Test Activation</h2>
                <form id="activateForm" class="space-y-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">License Key</label>
                        <input type="text" id="activateKey" placeholder="XXXX-XXXX-XXXX-XXXX" required
                            class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-indigo-500">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Domain</label>
                        <input type="text" id="activateDomain" value="testdomain.com" required
                            class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-indigo-500">
                    </div>
                    <button type="submit" class="w-full bg-indigo-600 text-white py-2 px-4 rounded-lg hover:bg-indigo-700 font-semibold">
                        Test Activate
                    </button>
                </form>
                <div id="activateResult" class="mt-4"></div>
            </div>
            
            <!-- Test Verify -->
            <div class="bg-white rounded-xl shadow-sm p-6 border border-gray-200">
                <h2 class="text-lg font-bold text-gray-900 mb-4">Test Verification</h2>
                <form id="verifyForm" class="space-y-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">License Key</label>
                        <input type="text" id="verifyKey" placeholder="XXXX-XXXX-XXXX-XXXX" required
                            class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-indigo-500">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Domain</label>
                        <input type="text" id="verifyDomain" value="testdomain.com" required
                            class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-indigo-500">
                    </div>
                    <button type="submit" class="w-full bg-green-600 text-white py-2 px-4 rounded-lg hover:bg-green-700 font-semibold">
                        Test Verify
                    </button>
                </form>
                <div id="verifyResult" class="mt-4"></div>
            </div>
        </div>
        
        <!-- Info -->
        <div class="mt-6 bg-blue-50 border border-blue-200 rounded-lg p-4">
            <p class="text-sm text-blue-800">
                <strong>📝 Note:</strong> Tool ini untuk testing API endpoints secara langsung. Pastikan License API server sudah running di <code class="bg-blue-100 px-2 py-1 rounded">http://127.0.0.1:8000</code>
            </p>
        </div>
    </div>
    
    <script>
        const API_BASE_URL = 'http://127.0.0.1:8000/api';
        
        // Test Activate
        document.getElementById('activateForm').addEventListener('submit', async (e) => {
            e.preventDefault();
            const resultDiv = document.getElementById('activateResult');
            resultDiv.innerHTML = '<p class="text-sm text-gray-500">Loading...</p>';
            
            try {
                const response = await fetch(`${API_BASE_URL}/activate`, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify({
                        key: document.getElementById('activateKey').value,
                        domain: document.getElementById('activateDomain').value
                    })
                });
                
                const data = await response.json();
                const isSuccess = response.ok;
                
                resultDiv.innerHTML = `
                    <div class="p-4 rounded-lg ${isSuccess ? 'bg-green-50 border border-green-200' : 'bg-red-50 border border-red-200'}">
                        <p class="text-sm font-semibold ${isSuccess ? 'text-green-800' : 'text-red-800'} mb-2">
                            ${isSuccess ? '✓ Success' : '✗ Error'} (${response.status})
                        </p>
                        <pre class="text-xs ${isSuccess ? 'text-green-700' : 'text-red-700'} overflow-auto">${JSON.stringify(data, null, 2)}</pre>
                    </div>
                `;
            } catch (error) {
                resultDiv.innerHTML = `
                    <div class="p-4 rounded-lg bg-red-50 border border-red-200">
                        <p class="text-sm font-semibold text-red-800 mb-2">✗ Connection Error</p>
                        <p class="text-xs text-red-700">${error.message}</p>
                    </div>
                `;
            }
        });
        
        // Test Verify
        document.getElementById('verifyForm').addEventListener('submit', async (e) => {
            e.preventDefault();
            const resultDiv = document.getElementById('verifyResult');
            resultDiv.innerHTML = '<p class="text-sm text-gray-500">Loading...</p>';
            
            try {
                const key = document.getElementById('verifyKey').value;
                const domain = document.getElementById('verifyDomain').value;
                
                const response = await fetch(`${API_BASE_URL}/verify?key=${encodeURIComponent(key)}&domain=${encodeURIComponent(domain)}`);
                
                const data = await response.json();
                const isSuccess = response.ok;
                
                resultDiv.innerHTML = `
                    <div class="p-4 rounded-lg ${isSuccess ? 'bg-green-50 border border-green-200' : 'bg-red-50 border border-red-200'}">
                        <p class="text-sm font-semibold ${isSuccess ? 'text-green-800' : 'text-red-800'} mb-2">
                            ${isSuccess ? '✓ Valid' : '✗ Invalid'} (${response.status})
                        </p>
                        <pre class="text-xs ${isSuccess ? 'text-green-700' : 'text-red-700'} overflow-auto">${JSON.stringify(data, null, 2)}</pre>
                    </div>
                `;
            } catch (error) {
                resultDiv.innerHTML = `
                    <div class="p-4 rounded-lg bg-red-50 border border-red-200">
                        <p class="text-sm font-semibold text-red-800 mb-2">✗ Connection Error</p>
                        <p class="text-xs text-red-700">${error.message}</p>
                    </div>
                `;
            }
        });
    </script>
</body>
</html>

