<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('licenses', function (Blueprint $table) {
            $table->string('customer_name')->after('license_key');
            $table->string('customer_email')->after('customer_name');
            $table->string('product_name')->after('customer_email');
            $table->enum('plan_type', ['basic', 'professional', 'premium', 'enterprise', 'trial'])->default('basic')->after('product_name');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('licenses', function (Blueprint $table) {
            $table->dropColumn(['customer_name', 'customer_email', 'product_name', 'plan_type']);
        });
    }
};
