<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class AdminUserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create default admin user
        User::create([
            'name' => 'Admin',
            'email' => 'admin@admin.com',
            'password' => Hash::make('password'),
            'role' => 'admin',
        ]);
        
        $this->command->info('✓ Default admin user created');
        $this->command->info('  Email: admin@admin.com');
        $this->command->info('  Password: password');
        $this->command->info('');
        $this->command->warn('⚠ IMPORTANT: Change the default password after first login!');
    }
}
