@extends('layouts.app')

@section('title', 'Analytics')
@section('page-title', 'Analytics Dashboard')
@section('page-subtitle', 'Insights and statistics')

@section('content')
<!-- Expiry Alerts -->
<div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-6">
    <div class="rounded-xl bg-red-50 p-6 shadow-sm border border-red-200">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-sm font-medium text-red-600">Expired</p>
                <p class="mt-2 text-3xl font-bold text-red-900">{{ $expiredCount }}</p>
            </div>
            <svg class="h-12 w-12 text-red-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
            </svg>
        </div>
    </div>
    <div class="rounded-xl bg-yellow-50 p-6 shadow-sm border border-yellow-200">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-sm font-medium text-yellow-600">Expiring in 7 Days</p>
                <p class="mt-2 text-3xl font-bold text-yellow-900">{{ $expiringIn7Days }}</p>
            </div>
            <svg class="h-12 w-12 text-yellow-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z" />
            </svg>
        </div>
    </div>
    <div class="rounded-xl bg-orange-50 p-6 shadow-sm border border-orange-200">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-sm font-medium text-orange-600">Expiring in 30 Days</p>
                <p class="mt-2 text-3xl font-bold text-orange-900">{{ $expiringIn30Days }}</p>
            </div>
            <svg class="h-12 w-12 text-orange-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
            </svg>
        </div>
    </div>
</div>

<div class="grid grid-cols-1 lg:grid-cols-2 gap-6 mb-6">
    <!-- Monthly Trend -->
    <div class="rounded-xl bg-white p-6 shadow-sm border border-gray-200">
        <h3 class="text-lg font-bold text-gray-900 mb-6">License Creation Trend (12 Months)</h3>
        <div class="h-64 flex items-end justify-between gap-1">
            @foreach($monthlyTrend as $data)
            <div class="flex-1 flex flex-col items-center gap-2">
                <div class="w-full bg-indigo-500 rounded-t hover:bg-indigo-600 transition-colors relative group" 
                     style="height: {{ $data['count'] > 0 ? max(($data['count'] / max(array_column($monthlyTrend->toArray(), 'count'))) * 100, 5) : 5 }}%">
                    <div class="absolute -top-8 left-1/2 transform -translate-x-1/2 bg-gray-900 text-white text-xs px-2 py-1 rounded opacity-0 group-hover:opacity-100 transition-opacity whitespace-nowrap">
                        {{ $data['count'] }} licenses
                    </div>
                </div>
                <span class="text-xs text-gray-500 transform rotate-45">{{ $data['month'] }}</span>
            </div>
            @endforeach
        </div>
    </div>

    <!-- Revenue by Plan Type -->
    <div class="rounded-xl bg-white p-6 shadow-sm border border-gray-200">
        <h3 class="text-lg font-bold text-gray-900 mb-6">Revenue by Plan Type</h3>
        <div class="space-y-4">
            @foreach($revenueByPlan as $plan => $revenue)
            <div>
                <div class="flex items-center justify-between mb-2">
                    <span class="text-sm font-medium text-gray-700 capitalize">{{ $plan }}</span>
                    <span class="text-sm font-semibold text-gray-900">${{ number_format($revenue) }}</span>
                </div>
                <div class="h-3 bg-gray-200 rounded-full overflow-hidden">
                    <div class="h-full {{ $plan === 'enterprise' ? 'bg-purple-500' : ($plan === 'premium' ? 'bg-blue-500' : ($plan === 'professional' ? 'bg-indigo-500' : ($plan === 'basic' ? 'bg-gray-500' : 'bg-yellow-500'))) }} transition-all" 
                         style="width: {{ array_sum($revenueByPlan) > 0 ? ($revenue / array_sum($revenueByPlan) * 100) : 0 }}%"></div>
                </div>
            </div>
            @endforeach
        </div>
        <div class="mt-4 pt-4 border-t border-gray-200">
            <div class="flex items-center justify-between">
                <span class="text-sm font-bold text-gray-900">Total Revenue</span>
                <span class="text-lg font-bold text-indigo-600">${{ number_format(array_sum($revenueByPlan)) }}</span>
            </div>
        </div>
    </div>
</div>

<div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
    <!-- Plan Distribution -->
    <div class="rounded-xl bg-white p-6 shadow-sm border border-gray-200">
        <h3 class="text-lg font-bold text-gray-900 mb-6">Plan Distribution</h3>
        <div class="space-y-3">
            @foreach($planDistribution as $plan)
            <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg">
                <div class="flex items-center gap-3">
                    <span class="inline-flex rounded-full px-3 py-1 text-xs font-semibold 
                        {{ $plan->plan_type === 'enterprise' ? 'bg-purple-100 text-purple-800' : '' }}
                        {{ $plan->plan_type === 'premium' ? 'bg-blue-100 text-blue-800' : '' }}
                        {{ $plan->plan_type === 'professional' ? 'bg-indigo-100 text-indigo-800' : '' }}
                        {{ $plan->plan_type === 'basic' ? 'bg-gray-100 text-gray-800' : '' }}
                        {{ $plan->plan_type === 'trial' ? 'bg-yellow-100 text-yellow-800' : '' }}">
                        {{ ucfirst($plan->plan_type) }}
                    </span>
                </div>
                <span class="text-lg font-bold text-gray-900">{{ $plan->count }}</span>
            </div>
            @endforeach
        </div>
    </div>

    <!-- Top Customers -->
    <div class="rounded-xl bg-white p-6 shadow-sm border border-gray-200">
        <h3 class="text-lg font-bold text-gray-900 mb-6">Top 10 Customers</h3>
        <div class="space-y-3">
            @foreach($topCustomers as $customer)
            <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg hover:bg-gray-100 transition-colors">
                <div class="flex items-center gap-3">
                    <div class="h-8 w-8 rounded-full bg-indigo-100 flex items-center justify-center text-indigo-600 font-semibold text-xs">
                        {{ strtoupper(substr($customer->customer_name, 0, 1)) }}{{ strtoupper(substr(explode(' ', $customer->customer_name)[1] ?? 'X', 0, 1)) }}
                    </div>
                    <div>
                        <p class="text-sm font-medium text-gray-900">{{ $customer->customer_name }}</p>
                        <p class="text-xs text-gray-500">{{ $customer->customer_email }}</p>
                    </div>
                </div>
                <div class="text-right">
                    <p class="text-sm font-bold text-gray-900">{{ $customer->license_count }} licenses</p>
                    <p class="text-xs text-green-600">{{ $customer->active_count }} active</p>
                </div>
            </div>
            @endforeach
        </div>
    </div>
</div>
@endsection

