@extends('layouts.app')

@section('title', 'Customers')
@section('page-title', 'Customers')
@section('page-subtitle', 'Manage customer accounts')

@section('content')
<!-- Search Bar -->
<div class="mb-6 rounded-xl bg-white p-6 shadow-sm border border-gray-200">
    <form method="GET" action="{{ route('customers.index') }}" class="flex gap-4">
        <div class="flex-1">
            <input type="text" name="search" value="{{ request('search') }}" placeholder="Search by name or email..." 
                class="w-full rounded-lg border border-gray-300 px-4 py-2 text-sm focus:border-indigo-500 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
        </div>
        <button type="submit" class="rounded-lg bg-indigo-600 px-6 py-2 text-sm font-semibold text-white shadow-sm hover:bg-indigo-700 transition-colors">
            Search
        </button>
        @if(request('search'))
        <a href="{{ route('customers.index') }}" class="rounded-lg bg-gray-100 px-6 py-2 text-sm font-semibold text-gray-700 hover:bg-gray-200 transition-colors">
            Clear
        </a>
        @endif
    </form>
</div>

<!-- Stats Cards -->
<div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-6">
    <div class="rounded-xl bg-white p-6 shadow-sm border border-gray-200">
        <p class="text-sm font-medium text-gray-600">Total Customers</p>
        <p class="mt-2 text-3xl font-bold text-gray-900">{{ $customers->total() }}</p>
    </div>
    <div class="rounded-xl bg-white p-6 shadow-sm border border-gray-200">
        <p class="text-sm font-medium text-gray-600">Avg Licenses/Customer</p>
        <p class="mt-2 text-3xl font-bold text-gray-900">{{ $customers->count() > 0 ? round($customers->sum('total_licenses') / $customers->count(), 1) : 0 }}</p>
    </div>
    <div class="rounded-xl bg-white p-6 shadow-sm border border-gray-200">
        <p class="text-sm font-medium text-gray-600">Total Active Licenses</p>
        <p class="mt-2 text-3xl font-bold text-gray-900">{{ $customers->sum('active_licenses') }}</p>
    </div>
    <div class="rounded-xl bg-white p-6 shadow-sm border border-gray-200">
        <p class="text-sm font-medium text-gray-600">Total Revenue</p>
        <p class="mt-2 text-3xl font-bold text-gray-900">${{ number_format($customers->sum('active_licenses') * 50) }}</p>
    </div>
</div>

<!-- Customers Table -->
<div class="rounded-xl bg-white shadow-sm border border-gray-200 overflow-hidden">
    <div class="overflow-x-auto">
        <table class="w-full">
            <thead class="bg-gray-50 border-b border-gray-200">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Customer</th>
                    <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Total Licenses</th>
                    <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Active Licenses</th>
                    <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Revenue</th>
                    <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Last License</th>
                    <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Actions</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-200 bg-white">
                @forelse($customers as $customer)
                <tr class="hover:bg-gray-50 transition-colors">
                    <td class="px-6 py-4">
                        <div class="flex items-center">
                            <div class="h-10 w-10 rounded-full bg-indigo-100 flex items-center justify-center text-indigo-600 font-semibold">
                                {{ strtoupper(substr($customer->customer_name, 0, 1)) }}{{ strtoupper(substr(explode(' ', $customer->customer_name)[1] ?? 'X', 0, 1)) }}
                            </div>
                            <div class="ml-3">
                                <p class="text-sm font-medium text-gray-900">{{ $customer->customer_name }}</p>
                                <p class="text-xs text-gray-500">{{ $customer->customer_email }}</p>
                            </div>
                        </div>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <span class="text-sm font-semibold text-gray-900">{{ $customer->total_licenses }}</span>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <span class="inline-flex rounded-full bg-green-100 px-3 py-1 text-xs font-semibold text-green-800">
                            {{ $customer->active_licenses }}
                        </span>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">
                        ${{ number_format($customer->active_licenses * 50) }}
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-700">
                        {{ \Carbon\Carbon::parse($customer->last_license_date)->format('M d, Y') }}
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm">
                        <div class="flex items-center gap-2">
                            <a href="{{ route('customers.show', urlencode($customer->customer_email)) }}" class="text-indigo-600 hover:text-indigo-900 font-medium">View</a>
                            <form method="POST" action="{{ route('customers.destroy', urlencode($customer->customer_email)) }}" class="inline" onsubmit="return confirm('Delete this customer and all their licenses?');">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="text-red-600 hover:text-red-900 font-medium">Delete</button>
                            </form>
                        </div>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="6" class="px-6 py-12 text-center text-gray-500">
                        <p class="text-lg font-medium">No customers found</p>
                    </td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    @if($customers->count() > 0)
    <div class="border-t border-gray-200 bg-gray-50 px-6 py-4">
        {{ $customers->links() }}
    </div>
    @endif
</div>
@endsection

