@extends('layouts.app')

@section('title', 'Customer Details')
@section('page-title', $customer['name'])
@section('page-subtitle', $customer['email'])

@section('content')
<!-- Stats Cards -->
<div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-6">
    <div class="rounded-xl bg-white p-6 shadow-sm border border-gray-200">
        <p class="text-sm font-medium text-gray-600">Total Licenses</p>
        <p class="mt-2 text-3xl font-bold text-gray-900">{{ $customer['total_licenses'] }}</p>
    </div>
    <div class="rounded-xl bg-white p-6 shadow-sm border border-gray-200">
        <p class="text-sm font-medium text-gray-600">Active Licenses</p>
        <p class="mt-2 text-3xl font-bold text-green-600">{{ $customer['active_licenses'] }}</p>
    </div>
    <div class="rounded-xl bg-white p-6 shadow-sm border border-gray-200">
        <p class="text-sm font-medium text-gray-600">Expired Licenses</p>
        <p class="mt-2 text-3xl font-bold text-red-600">{{ $customer['expired_licenses'] }}</p>
    </div>
    <div class="rounded-xl bg-white p-6 shadow-sm border border-gray-200">
        <p class="text-sm font-medium text-gray-600">Total Revenue</p>
        <p class="mt-2 text-3xl font-bold text-gray-900">${{ number_format($customer['total_revenue']) }}</p>
    </div>
</div>

<!-- Customer Info -->
<div class="grid grid-cols-1 lg:grid-cols-3 gap-6 mb-6">
    <div class="rounded-xl bg-white p-6 shadow-sm border border-gray-200">
        <h3 class="text-lg font-bold text-gray-900 mb-4">Customer Information</h3>
        <div class="space-y-3">
            <div>
                <label class="block text-sm font-medium text-gray-500">Name</label>
                <p class="text-sm font-semibold text-gray-900">{{ $customer['name'] }}</p>
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-500">Email</label>
                <p class="text-sm text-gray-900">{{ $customer['email'] }}</p>
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-500">Customer Since</label>
                <p class="text-sm text-gray-900">{{ \Carbon\Carbon::parse($customer['first_license'])->format('F d, Y') }}</p>
            </div>
        </div>
    </div>
</div>

<!-- Licenses Table -->
<div class="rounded-xl bg-white shadow-sm border border-gray-200 overflow-hidden">
    <div class="border-b border-gray-200 bg-gray-50 px-6 py-4">
        <h3 class="text-lg font-bold text-gray-900">License History</h3>
    </div>
    <div class="overflow-x-auto">
        <table class="w-full">
            <thead class="bg-gray-50 border-b border-gray-200">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase">License Key</th>
                    <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase">Product</th>
                    <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase">Plan</th>
                    <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase">Status</th>
                    <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase">Domain</th>
                    <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase">Expires</th>
                    <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase">Actions</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-200 bg-white">
                @foreach($customerLicenses as $license)
                <tr class="hover:bg-gray-50">
                    <td class="px-6 py-4 whitespace-nowrap font-mono text-sm">{{ $license->license_key }}</td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm">{{ $license->product_name }}</td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <span class="inline-flex rounded-full px-2 py-1 text-xs font-semibold 
                            {{ $license->plan_type === 'enterprise' ? 'bg-purple-100 text-purple-800' : '' }}
                            {{ $license->plan_type === 'premium' ? 'bg-blue-100 text-blue-800' : '' }}
                            {{ $license->plan_type === 'professional' ? 'bg-indigo-100 text-indigo-800' : '' }}
                            {{ $license->plan_type === 'basic' ? 'bg-gray-100 text-gray-800' : '' }}
                            {{ $license->plan_type === 'trial' ? 'bg-yellow-100 text-yellow-800' : '' }}">
                            {{ ucfirst($license->plan_type) }}
                        </span>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        @if($license->expired_at && $license->expired_at < now())
                            <span class="inline-flex rounded-full bg-red-100 px-3 py-1 text-xs font-semibold text-red-800">Expired</span>
                        @elseif($license->status === 'active')
                            <span class="inline-flex rounded-full bg-green-100 px-3 py-1 text-xs font-semibold text-green-800">Active</span>
                        @elseif($license->status === 'suspended')
                            <span class="inline-flex rounded-full bg-orange-100 px-3 py-1 text-xs font-semibold text-orange-800">Suspended</span>
                        @else
                            <span class="inline-flex rounded-full bg-gray-100 px-3 py-1 text-xs font-semibold text-gray-800">Inactive</span>
                        @endif
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm">{{ $license->domain ?? '-' }}</td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm">{{ $license->expired_at ? $license->expired_at->format('M d, Y') : 'N/A' }}</td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm">
                        <a href="{{ route('licenses.show', $license) }}" class="text-indigo-600 hover:text-indigo-900 font-medium">View</a>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>

<div class="mt-6">
    <a href="{{ route('customers.index') }}" class="text-indigo-600 hover:text-indigo-900 font-medium">
        ← Back to Customers
    </a>
</div>
@endsection

