@extends('layouts.app')

@section('title', 'Create New License')
@section('page-title', 'Create New License')
@section('page-subtitle', 'Add a new license to the system')

@section('content')
<div class="max-w-3xl">
    <div class="rounded-xl bg-white p-6 shadow-sm border border-gray-200">
        <form method="POST" action="{{ route('licenses.store') }}">
            @csrf

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Customer Name -->
                <div>
                    <label for="customer_name" class="block text-sm font-medium text-gray-700 mb-2">Customer Name *</label>
                    <input type="text" name="customer_name" id="customer_name" value="{{ old('customer_name') }}" required
                        class="w-full rounded-lg border border-gray-300 px-4 py-2 text-sm focus:border-indigo-500 focus:outline-none focus:ring-2 focus:ring-indigo-500/20 @error('customer_name') border-red-500 @enderror">
                    @error('customer_name')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Customer Email -->
                <div>
                    <label for="customer_email" class="block text-sm font-medium text-gray-700 mb-2">Customer Email *</label>
                    <input type="email" name="customer_email" id="customer_email" value="{{ old('customer_email') }}" required
                        class="w-full rounded-lg border border-gray-300 px-4 py-2 text-sm focus:border-indigo-500 focus:outline-none focus:ring-2 focus:ring-indigo-500/20 @error('customer_email') border-red-500 @enderror">
                    @error('customer_email')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Product Name -->
                <div>
                    <label for="product_name" class="block text-sm font-medium text-gray-700 mb-2">Product Name *</label>
                    <input type="text" name="product_name" id="product_name" value="{{ old('product_name') }}" required
                        class="w-full rounded-lg border border-gray-300 px-4 py-2 text-sm focus:border-indigo-500 focus:outline-none focus:ring-2 focus:ring-indigo-500/20 @error('product_name') border-red-500 @enderror">
                    @error('product_name')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Plan Type -->
                <div>
                    <label for="plan_type" class="block text-sm font-medium text-gray-700 mb-2">Plan Type *</label>
                    <select name="plan_type" id="plan_type" required
                        class="w-full rounded-lg border border-gray-300 px-4 py-2 text-sm focus:border-indigo-500 focus:outline-none focus:ring-2 focus:ring-indigo-500/20 @error('plan_type') border-red-500 @enderror">
                        <option value="">Select Plan Type</option>
                        <option value="basic" {{ old('plan_type') === 'basic' ? 'selected' : '' }}>Basic</option>
                        <option value="professional" {{ old('plan_type') === 'professional' ? 'selected' : '' }}>Professional</option>
                        <option value="premium" {{ old('plan_type') === 'premium' ? 'selected' : '' }}>Premium</option>
                        <option value="enterprise" {{ old('plan_type') === 'enterprise' ? 'selected' : '' }}>Enterprise</option>
                        <option value="trial" {{ old('plan_type') === 'trial' ? 'selected' : '' }}>Trial</option>
                    </select>
                    @error('plan_type')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Status -->
                <div>
                    <label for="status" class="block text-sm font-medium text-gray-700 mb-2">Status *</label>
                    <select name="status" id="status" required
                        class="w-full rounded-lg border border-gray-300 px-4 py-2 text-sm focus:border-indigo-500 focus:outline-none focus:ring-2 focus:ring-indigo-500/20 @error('status') border-red-500 @enderror">
                        <option value="inactive" {{ old('status') === 'inactive' ? 'selected' : '' }}>Inactive</option>
                        <option value="active" {{ old('status') === 'active' ? 'selected' : '' }}>Active</option>
                        <option value="suspended" {{ old('status') === 'suspended' ? 'selected' : '' }}>Suspended</option>
                    </select>
                    @error('status')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Expiry Date -->
                <div>
                    <label for="expired_at" class="block text-sm font-medium text-gray-700 mb-2">Expiry Date *</label>
                    <input type="date" name="expired_at" id="expired_at" value="{{ old('expired_at', now()->addYear()->format('Y-m-d')) }}" required
                        class="w-full rounded-lg border border-gray-300 px-4 py-2 text-sm focus:border-indigo-500 focus:outline-none focus:ring-2 focus:ring-indigo-500/20 @error('expired_at') border-red-500 @enderror">
                    @error('expired_at')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Domain (Optional) -->
                <div>
                    <label for="domain" class="block text-sm font-medium text-gray-700 mb-2">Domain (Optional)</label>
                    <input type="text" name="domain" id="domain" value="{{ old('domain') }}" placeholder="example.com"
                        class="w-full rounded-lg border border-gray-300 px-4 py-2 text-sm focus:border-indigo-500 focus:outline-none focus:ring-2 focus:ring-indigo-500/20 @error('domain') border-red-500 @enderror">
                    @error('domain')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- IP Address (Optional) -->
                <div>
                    <label for="ip_address" class="block text-sm font-medium text-gray-700 mb-2">IP Address (Optional)</label>
                    <input type="text" name="ip_address" id="ip_address" value="{{ old('ip_address') }}" placeholder="192.168.1.1"
                        class="w-full rounded-lg border border-gray-300 px-4 py-2 text-sm focus:border-indigo-500 focus:outline-none focus:ring-2 focus:ring-indigo-500/20 @error('ip_address') border-red-500 @enderror">
                    @error('ip_address')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>
            </div>

            <div class="mt-6 pt-6 border-t border-gray-200">
                <div class="bg-blue-50 border border-blue-200 rounded-lg p-4 mb-6">
                    <div class="flex">
                        <svg class="h-5 w-5 text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                        </svg>
                        <div class="ml-3">
                            <p class="text-sm text-blue-800">
                                <strong>Note:</strong> A unique license key will be automatically generated when you create this license.
                            </p>
                        </div>
                    </div>
                </div>

                <div class="flex items-center gap-4">
                    <button type="submit" class="rounded-lg bg-indigo-600 px-6 py-2 text-sm font-semibold text-white shadow-sm hover:bg-indigo-700 transition-colors">
                        Create License
                    </button>
                    <a href="{{ route('licenses.index') }}" class="rounded-lg bg-gray-100 px-6 py-2 text-sm font-semibold text-gray-700 hover:bg-gray-200 transition-colors">
                        Cancel
                    </a>
                </div>
            </div>
        </form>
    </div>
</div>
@endsection

