@extends('layouts.app')

@section('title', 'Edit License')
@section('page-title', 'Edit License')
@section('page-subtitle', 'Update license information')

@section('content')
<div class="max-w-3xl">
    <div class="rounded-xl bg-white p-6 shadow-sm border border-gray-200">
        <form method="POST" action="{{ route('licenses.update', $license) }}">
            @csrf
            @method('PUT')

            <div class="mb-6 bg-gray-50 rounded-lg p-4">
                <label class="block text-sm font-medium text-gray-700 mb-2">License Key</label>
                <p class="font-mono text-lg font-bold text-indigo-600">{{ $license->license_key }}</p>
                <p class="text-xs text-gray-500 mt-1">License key cannot be changed</p>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label for="customer_name" class="block text-sm font-medium text-gray-700 mb-2">Customer Name *</label>
                    <input type="text" name="customer_name" id="customer_name" value="{{ old('customer_name', $license->customer_name) }}" required
                        class="w-full rounded-lg border border-gray-300 px-4 py-2 text-sm focus:border-indigo-500 focus:outline-none focus:ring-2 focus:ring-indigo-500/20 @error('customer_name') border-red-500 @enderror">
                    @error('customer_name')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label for="customer_email" class="block text-sm font-medium text-gray-700 mb-2">Customer Email *</label>
                    <input type="email" name="customer_email" id="customer_email" value="{{ old('customer_email', $license->customer_email) }}" required
                        class="w-full rounded-lg border border-gray-300 px-4 py-2 text-sm focus:border-indigo-500 focus:outline-none focus:ring-2 focus:ring-indigo-500/20 @error('customer_email') border-red-500 @enderror">
                    @error('customer_email')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label for="product_name" class="block text-sm font-medium text-gray-700 mb-2">Product Name *</label>
                    <input type="text" name="product_name" id="product_name" value="{{ old('product_name', $license->product_name) }}" required
                        class="w-full rounded-lg border border-gray-300 px-4 py-2 text-sm focus:border-indigo-500 focus:outline-none focus:ring-2 focus:ring-indigo-500/20 @error('product_name') border-red-500 @enderror">
                    @error('product_name')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label for="plan_type" class="block text-sm font-medium text-gray-700 mb-2">Plan Type *</label>
                    <select name="plan_type" id="plan_type" required
                        class="w-full rounded-lg border border-gray-300 px-4 py-2 text-sm focus:border-indigo-500 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                        <option value="basic" {{ old('plan_type', $license->plan_type) === 'basic' ? 'selected' : '' }}>Basic</option>
                        <option value="professional" {{ old('plan_type', $license->plan_type) === 'professional' ? 'selected' : '' }}>Professional</option>
                        <option value="premium" {{ old('plan_type', $license->plan_type) === 'premium' ? 'selected' : '' }}>Premium</option>
                        <option value="enterprise" {{ old('plan_type', $license->plan_type) === 'enterprise' ? 'selected' : '' }}>Enterprise</option>
                        <option value="trial" {{ old('plan_type', $license->plan_type) === 'trial' ? 'selected' : '' }}>Trial</option>
                    </select>
                </div>

                <div>
                    <label for="status" class="block text-sm font-medium text-gray-700 mb-2">Status *</label>
                    <select name="status" id="status" required
                        class="w-full rounded-lg border border-gray-300 px-4 py-2 text-sm focus:border-indigo-500 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                        <option value="inactive" {{ old('status', $license->status) === 'inactive' ? 'selected' : '' }}>Inactive</option>
                        <option value="active" {{ old('status', $license->status) === 'active' ? 'selected' : '' }}>Active</option>
                        <option value="suspended" {{ old('status', $license->status) === 'suspended' ? 'selected' : '' }}>Suspended</option>
                    </select>
                </div>

                <div>
                    <label for="expired_at" class="block text-sm font-medium text-gray-700 mb-2">Expiry Date *</label>
                    <input type="date" name="expired_at" id="expired_at" value="{{ old('expired_at', $license->expired_at?->format('Y-m-d')) }}" required
                        class="w-full rounded-lg border border-gray-300 px-4 py-2 text-sm focus:border-indigo-500 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                </div>

                <div>
                    <label for="domain" class="block text-sm font-medium text-gray-700 mb-2">Domain</label>
                    <input type="text" name="domain" id="domain" value="{{ old('domain', $license->domain) }}"
                        class="w-full rounded-lg border border-gray-300 px-4 py-2 text-sm focus:border-indigo-500 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                </div>

                <div>
                    <label for="ip_address" class="block text-sm font-medium text-gray-700 mb-2">IP Address</label>
                    <input type="text" name="ip_address" id="ip_address" value="{{ old('ip_address', $license->ip_address) }}"
                        class="w-full rounded-lg border border-gray-300 px-4 py-2 text-sm focus:border-indigo-500 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                </div>
            </div>

            <div class="mt-6 pt-6 border-t border-gray-200 flex items-center gap-4">
                <button type="submit" class="rounded-lg bg-indigo-600 px-6 py-2 text-sm font-semibold text-white shadow-sm hover:bg-indigo-700 transition-colors">
                    Update License
                </button>
                <a href="{{ route('licenses.index') }}" class="rounded-lg bg-gray-100 px-6 py-2 text-sm font-semibold text-gray-700 hover:bg-gray-200 transition-colors">
                    Cancel
                </a>
            </div>
        </form>
    </div>
</div>
@endsection

