@extends('layouts.app')

@section('title', 'License Details')
@section('page-title', 'License Details')
@section('page-subtitle', 'View complete license information')

@section('header-actions')
<a href="{{ route('licenses.edit', $license) }}" class="rounded-lg bg-indigo-600 px-4 py-2 text-sm font-semibold text-white shadow-sm hover:bg-indigo-700 transition-colors">
    Edit License
</a>
@endsection

@section('content')
<div class="max-w-4xl">
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Main Info -->
        <div class="lg:col-span-2 rounded-xl bg-white p-6 shadow-sm border border-gray-200">
            <h3 class="text-lg font-bold text-gray-900 mb-6">License Information</h3>
            
            <div class="space-y-4">
                <div class="grid grid-cols-2 gap-4 pb-4 border-b border-gray-200">
                    <div>
                        <label class="block text-sm font-medium text-gray-500 mb-1">License Key</label>
                        <p class="font-mono text-lg font-bold text-indigo-600">{{ $license->license_key }}</p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-500 mb-1">Status</label>
                        @if($license->expired_at && $license->expired_at < now())
                            <span class="inline-flex rounded-full bg-red-100 px-3 py-1 text-xs font-semibold text-red-800">Expired</span>
                        @elseif($license->status === 'active')
                            <span class="inline-flex rounded-full bg-green-100 px-3 py-1 text-xs font-semibold text-green-800">Active</span>
                        @elseif($license->status === 'suspended')
                            <span class="inline-flex rounded-full bg-orange-100 px-3 py-1 text-xs font-semibold text-orange-800">Suspended</span>
                        @else
                            <span class="inline-flex rounded-full bg-gray-100 px-3 py-1 text-xs font-semibold text-gray-800">Inactive</span>
                        @endif
                    </div>
                </div>

                <div class="grid grid-cols-2 gap-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-500 mb-1">Customer Name</label>
                        <p class="text-sm font-semibold text-gray-900">{{ $license->customer_name }}</p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-500 mb-1">Customer Email</label>
                        <p class="text-sm text-gray-900">{{ $license->customer_email }}</p>
                    </div>
                </div>

                <div class="grid grid-cols-2 gap-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-500 mb-1">Product Name</label>
                        <p class="text-sm text-gray-900">{{ $license->product_name }}</p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-500 mb-1">Plan Type</label>
                        <span class="inline-flex rounded-full px-2 py-1 text-xs font-semibold 
                            {{ $license->plan_type === 'enterprise' ? 'bg-purple-100 text-purple-800' : '' }}
                            {{ $license->plan_type === 'premium' ? 'bg-blue-100 text-blue-800' : '' }}
                            {{ $license->plan_type === 'professional' ? 'bg-indigo-100 text-indigo-800' : '' }}
                            {{ $license->plan_type === 'basic' ? 'bg-gray-100 text-gray-800' : '' }}
                            {{ $license->plan_type === 'trial' ? 'bg-yellow-100 text-yellow-800' : '' }}">
                            {{ ucfirst($license->plan_type) }}
                        </span>
                    </div>
                </div>

                <div class="grid grid-cols-2 gap-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-500 mb-1">Domain</label>
                        <p class="text-sm text-gray-900">{{ $license->domain ?? 'Not assigned' }}</p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-500 mb-1">IP Address</label>
                        <p class="text-sm text-gray-900">{{ $license->ip_address ?? 'Not assigned' }}</p>
                    </div>
                </div>

                <div class="grid grid-cols-2 gap-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-500 mb-1">Expiry Date</label>
                        <p class="text-sm text-gray-900">{{ $license->expired_at ? $license->expired_at->format('F d, Y') : 'N/A' }}</p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-500 mb-1">Created At</label>
                        <p class="text-sm text-gray-900">{{ $license->created_at->format('F d, Y H:i:s') }}</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Quick Actions -->
        <div class="space-y-6">
            <div class="rounded-xl bg-white p-6 shadow-sm border border-gray-200">
                <h3 class="text-lg font-bold text-gray-900 mb-4">Quick Actions</h3>
                <div class="space-y-3">
                    <a href="{{ route('licenses.edit', $license) }}" class="block w-full text-center rounded-lg bg-indigo-600 px-4 py-2 text-sm font-semibold text-white shadow-sm hover:bg-indigo-700 transition-colors">
                        Edit License
                    </a>
                    <form method="POST" action="{{ route('licenses.destroy', $license) }}" onsubmit="return confirm('Are you sure?');">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="block w-full text-center rounded-lg bg-red-600 px-4 py-2 text-sm font-semibold text-white shadow-sm hover:bg-red-700 transition-colors">
                            Delete License
                        </button>
                    </form>
                    <a href="{{ route('licenses.index') }}" class="block w-full text-center rounded-lg bg-gray-100 px-4 py-2 text-sm font-semibold text-gray-700 hover:bg-gray-200 transition-colors">
                        Back to List
                    </a>
                </div>
            </div>

            @if($license->expired_at)
            <div class="rounded-xl bg-white p-6 shadow-sm border border-gray-200">
                <h3 class="text-lg font-bold text-gray-900 mb-4">Expiry Info</h3>
                @if($license->expired_at < now())
                    <div class="text-center">
                        <p class="text-3xl font-bold text-red-600 mb-2">Expired</p>
                        <p class="text-sm text-gray-600">{{ $license->expired_at->diffForHumans() }}</p>
                    </div>
                @else
                    <div class="text-center">
                        <p class="text-3xl font-bold text-green-600 mb-2">{{ $license->expired_at->diffInDays() }}</p>
                        <p class="text-sm text-gray-600">days remaining</p>
                    </div>
                @endif
            </div>
            @endif
        </div>
    </div>
</div>
@endsection

