@extends('layouts.app')

@section('title', 'Settings')
@section('page-title', 'Settings')
@section('page-subtitle', 'Manage system configuration')

@section('content')
<div class="max-w-4xl">
    <!-- Application Settings -->
    <div class="rounded-xl bg-white p-6 shadow-sm border border-gray-200 mb-6">
        <h3 class="text-lg font-bold text-gray-900 mb-6">Application Settings</h3>
        <form method="POST" action="{{ route('settings.update') }}">
            @csrf
            @method('PUT')

            <div class="space-y-6">
                <div>
                    <label for="app_name" class="block text-sm font-medium text-gray-700 mb-2">Application Name</label>
                    <input type="text" name="app_name" id="app_name" value="{{ $settings['app_name'] }}"
                        class="w-full rounded-lg border border-gray-300 px-4 py-2 text-sm focus:border-indigo-500 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                </div>

                <div>
                    <label for="app_url" class="block text-sm font-medium text-gray-700 mb-2">Application URL</label>
                    <input type="url" name="app_url" id="app_url" value="{{ $settings['app_url'] }}"
                        class="w-full rounded-lg border border-gray-300 px-4 py-2 text-sm focus:border-indigo-500 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                </div>

                <div>
                    <label for="timezone" class="block text-sm font-medium text-gray-700 mb-2">Timezone</label>
                    <select name="timezone" id="timezone" class="w-full rounded-lg border border-gray-300 px-4 py-2 text-sm focus:border-indigo-500 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                        <option value="UTC" {{ $settings['timezone'] === 'UTC' ? 'selected' : '' }}>UTC</option>
                        <option value="Asia/Jakarta" {{ $settings['timezone'] === 'Asia/Jakarta' ? 'selected' : '' }}>Asia/Jakarta</option>
                        <option value="America/New_York" {{ $settings['timezone'] === 'America/New_York' ? 'selected' : '' }}>America/New_York</option>
                        <option value="Europe/London" {{ $settings['timezone'] === 'Europe/London' ? 'selected' : '' }}>Europe/London</option>
                    </select>
                </div>

                <div>
                    <label for="locale" class="block text-sm font-medium text-gray-700 mb-2">Language</label>
                    <select name="locale" id="locale" class="w-full rounded-lg border border-gray-300 px-4 py-2 text-sm focus:border-indigo-500 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                        <option value="en" {{ $settings['locale'] === 'en' ? 'selected' : '' }}>English</option>
                        <option value="id" {{ $settings['locale'] === 'id' ? 'selected' : '' }}>Indonesian</option>
                    </select>
                </div>

                <div class="flex items-center gap-3">
                    <input type="checkbox" name="debug_mode" id="debug_mode" {{ $settings['debug_mode'] ? 'checked' : '' }}
                        class="rounded border-gray-300 text-indigo-600 focus:ring-indigo-500">
                    <label for="debug_mode" class="text-sm font-medium text-gray-700">Enable Debug Mode</label>
                </div>
            </div>

            <div class="mt-6 pt-6 border-t border-gray-200">
                <button type="submit" class="rounded-lg bg-indigo-600 px-6 py-2 text-sm font-semibold text-white shadow-sm hover:bg-indigo-700 transition-colors">
                    Save Changes
                </button>
            </div>
        </form>
    </div>

    <!-- System Information -->
    <div class="rounded-xl bg-white p-6 shadow-sm border border-gray-200 mb-6">
        <h3 class="text-lg font-bold text-gray-900 mb-6">System Information</h3>
        <div class="grid grid-cols-2 gap-6">
            <div>
                <label class="block text-sm font-medium text-gray-500 mb-1">PHP Version</label>
                <p class="text-sm font-semibold text-gray-900">{{ PHP_VERSION }}</p>
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-500 mb-1">Laravel Version</label>
                <p class="text-sm font-semibold text-gray-900">{{ app()->version() }}</p>
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-500 mb-1">Environment</label>
                <p class="text-sm font-semibold text-gray-900">{{ config('app.env') }}</p>
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-500 mb-1">Database</label>
                <p class="text-sm font-semibold text-gray-900">{{ config('database.default') }}</p>
            </div>
        </div>
    </div>

    <!-- API Settings -->
    <div class="rounded-xl bg-white p-6 shadow-sm border border-gray-200 mb-6">
        <h3 class="text-lg font-bold text-gray-900 mb-6">API Endpoints</h3>
        <div class="space-y-4">
            <div class="flex items-center justify-between p-4 bg-gray-50 rounded-lg">
                <div>
                    <p class="text-sm font-medium text-gray-900">Check License</p>
                    <p class="text-xs text-gray-500 font-mono mt-1">POST /api/license/check</p>
                </div>
                <span class="inline-flex rounded-full bg-green-100 px-3 py-1 text-xs font-semibold text-green-800">Active</span>
            </div>
            <div class="flex items-center justify-between p-4 bg-gray-50 rounded-lg">
                <div>
                    <p class="text-sm font-medium text-gray-900">Activate License</p>
                    <p class="text-xs text-gray-500 font-mono mt-1">POST /api/license/activate</p>
                </div>
                <span class="inline-flex rounded-full bg-green-100 px-3 py-1 text-xs font-semibold text-green-800">Active</span>
            </div>
        </div>
    </div>

    <!-- Danger Zone -->
    <div class="rounded-xl bg-red-50 p-6 shadow-sm border border-red-200">
        <h3 class="text-lg font-bold text-red-900 mb-2">Danger Zone</h3>
        <p class="text-sm text-red-700 mb-4">Irreversible and destructive actions</p>
        <div class="space-y-3">
            <button type="button" onclick="alert('This would clear all caches in production')" 
                class="rounded-lg bg-red-600 px-4 py-2 text-sm font-semibold text-white shadow-sm hover:bg-red-700 transition-colors">
                Clear All Caches
            </button>
            <button type="button" onclick="alert('This would reset all settings in production')" 
                class="ml-3 rounded-lg bg-red-600 px-4 py-2 text-sm font-semibold text-white shadow-sm hover:bg-red-700 transition-colors">
                Reset to Defaults
            </button>
        </div>
    </div>
</div>
@endsection

