<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <title>License API Dashboard - {{ config('app.name', 'Laravel') }}</title>

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=inter:400,500,600,700" rel="stylesheet" />

        <!-- Styles / Scripts -->
        @if (file_exists(public_path('build/manifest.json')) || file_exists(public_path('hot')))
            @vite(['resources/css/app.css', 'resources/js/app.js'])
        @else
            <script src="https://cdn.tailwindcss.com"></script>
        @endif
        
        <style>
            body {
                font-family: 'Inter', sans-serif;
            }
        </style>
    </head>
    <body class="bg-gray-50 antialiased">
        <!-- Sidebar -->
        <div class="fixed inset-y-0 left-0 z-50 w-64 bg-gradient-to-b from-indigo-600 to-indigo-800 shadow-xl">
            <div class="flex h-full flex-col">
                <!-- Logo -->
                <div class="flex h-16 items-center justify-center border-b border-indigo-500/30 px-6">
                    <a href="{{ route('dashboard') }}" class="text-2xl font-bold text-white flex items-center gap-2 hover:opacity-90 transition-opacity">
                        <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 7a2 2 0 012 2m4 0a6 6 0 01-7.743 5.743L11 17H9v2H7v2H4a1 1 0 01-1-1v-2.586a1 1 0 01.293-.707l5.964-5.964A6 6 0 1121 9z" />
                        </svg>
                        <span>License API</span>
                    </a>
                </div>

                <!-- Navigation -->
                <nav class="flex-1 space-y-1 px-3 py-4">
                    <a href="{{ route('dashboard') }}" class="flex items-center gap-3 rounded-lg bg-indigo-700/50 px-3 py-2.5 text-sm font-medium text-white transition-colors">
                        <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6" />
                        </svg>
                            Dashboard
                    </a>
                    <a href="{{ route('licenses.index') }}" class="flex items-center gap-3 rounded-lg px-3 py-2.5 text-sm font-medium text-indigo-100 hover:bg-indigo-700/30 hover:text-white transition-colors">
                        <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 7a2 2 0 012 2m4 0a6 6 0 01-7.743 5.743L11 17H9v2H7v2H4a1 1 0 01-1-1v-2.586a1 1 0 01.293-.707l5.964-5.964A6 6 0 1121 9z" />
                        </svg>
                        Licenses
                    </a>
                    <a href="{{ route('customers.index') }}" class="flex items-center gap-3 rounded-lg px-3 py-2.5 text-sm font-medium text-indigo-100 hover:bg-indigo-700/30 hover:text-white transition-colors">
                        <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z" />
                        </svg>
                        Customers
                    </a>
                    <a href="{{ route('analytics.index') }}" class="flex items-center gap-3 rounded-lg px-3 py-2.5 text-sm font-medium text-indigo-100 hover:bg-indigo-700/30 hover:text-white transition-colors">
                        <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z" />
                        </svg>
                        Analytics
                    </a>
                    <a href="{{ route('settings.index') }}" class="flex items-center gap-3 rounded-lg px-3 py-2.5 text-sm font-medium text-indigo-100 hover:bg-indigo-700/30 hover:text-white transition-colors">
                        <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z" />
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                        </svg>
                        Settings
                    </a>
                </nav>

                <!-- User Profile -->
                <div class="border-t border-indigo-500/30 p-4">
                    <div class="flex items-center gap-3">
                        <div class="h-10 w-10 rounded-full bg-indigo-500 flex items-center justify-center text-white font-semibold">
                            AD
                        </div>
                        <div class="flex-1">
                            <p class="text-sm font-medium text-white">Admin User</p>
                            <p class="text-xs text-indigo-200">admin@license.com</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Main Content -->
        <div class="pl-64">
            <!-- Header -->
            <header class="sticky top-0 z-40 bg-white border-b border-gray-200 shadow-sm">
                <div class="flex h-16 items-center justify-between px-8">
                    <div>
                        <h2 class="text-2xl font-bold text-gray-900">Dashboard</h2>
                        <p class="text-sm text-gray-500">Welcome back, Admin!</p>
                    </div>
                    
                    <div class="flex items-center gap-4">
                        <!-- Search -->
                        <div class="relative">
                            <input type="text" placeholder="Search licenses..." class="w-64 rounded-lg border border-gray-300 bg-gray-50 px-4 py-2 pl-10 text-sm focus:border-indigo-500 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                            <svg class="absolute left-3 top-2.5 h-5 w-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z" />
                            </svg>
                        </div>

                        <!-- Notifications -->
                        <button class="relative rounded-lg p-2 text-gray-500 hover:bg-gray-100 hover:text-gray-700">
                            <svg class="h-6 w-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9" />
                            </svg>
                            <span class="absolute right-1 top-1 h-2 w-2 rounded-full bg-red-500"></span>
                        </button>

                        @if (Route::has('login'))
                            @auth
                                <a href="{{ url('/dashboard') }}" class="rounded-lg bg-indigo-600 px-4 py-2 text-sm font-semibold text-white shadow-sm hover:bg-indigo-700 transition-colors">
                                    Go to Dashboard
                        </a>
                    @else
                                <a href="{{ route('login') }}" class="text-sm font-semibold text-gray-700 hover:text-indigo-600 transition-colors">
                            Log in
                        </a>
                        @if (Route::has('register'))
                                    <a href="{{ route('register') }}" class="rounded-lg bg-indigo-600 px-4 py-2 text-sm font-semibold text-white shadow-sm hover:bg-indigo-700 transition-colors">
                                Register
                            </a>
                        @endif
                    @endauth
            @endif
                    </div>
                </div>
        </header>

            <!-- Dashboard Content -->
            <main class="p-8">
                <!-- Stats Cards -->
                <div class="grid grid-cols-1 gap-6 sm:grid-cols-2 lg:grid-cols-4 mb-8">
                    <!-- Total Licenses -->
                    <div class="relative overflow-hidden rounded-xl bg-white p-6 shadow-sm border border-gray-200 hover:shadow-md transition-shadow">
                        <div class="flex items-center justify-between">
                            <div>
                                <p class="text-sm font-medium text-gray-600">Total Licenses</p>
                                <p class="mt-2 text-3xl font-bold text-gray-900">{{ number_format($stats['total']) }}</p>
                                <div class="mt-2 flex items-center text-sm">
                                    <span class="font-semibold {{ $growth['total'] >= 0 ? 'text-green-600' : 'text-red-600' }}">
                                        {{ $growth['total'] >= 0 ? '+' : '' }}{{ number_format($growth['total'], 1) }}%
                                </span>
                                    <span class="ml-2 text-gray-500">from last month</span>
                                </div>
                            </div>
                            <div class="rounded-full bg-indigo-100 p-3">
                                <svg class="h-8 w-8 text-indigo-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 7a2 2 0 012 2m4 0a6 6 0 01-7.743 5.743L11 17H9v2H7v2H4a1 1 0 01-1-1v-2.586a1 1 0 01.293-.707l5.964-5.964A6 6 0 1121 9z" />
                                </svg>
                            </div>
                        </div>
                    </div>

                    <!-- Active Licenses -->
                    <div class="relative overflow-hidden rounded-xl bg-white p-6 shadow-sm border border-gray-200 hover:shadow-md transition-shadow">
                        <div class="flex items-center justify-between">
                            <div>
                                <p class="text-sm font-medium text-gray-600">Active Licenses</p>
                                <p class="mt-2 text-3xl font-bold text-gray-900">{{ number_format($stats['active']) }}</p>
                                <div class="mt-2 flex items-center text-sm">
                                    <span class="font-semibold {{ $growth['active'] >= 0 ? 'text-green-600' : 'text-red-600' }}">
                                        {{ $growth['active'] >= 0 ? '+' : '' }}{{ number_format($growth['active'], 1) }}%
                            </span>
                                    <span class="ml-2 text-gray-500">from last month</span>
                                </div>
                            </div>
                            <div class="rounded-full bg-green-100 p-3">
                                <svg class="h-8 w-8 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                                    </svg>
                            </div>
                        </div>
                    </div>

                    <!-- Expired Licenses -->
                    <div class="relative overflow-hidden rounded-xl bg-white p-6 shadow-sm border border-gray-200 hover:shadow-md transition-shadow">
                        <div class="flex items-center justify-between">
                            <div>
                                <p class="text-sm font-medium text-gray-600">Expired Licenses</p>
                                <p class="mt-2 text-3xl font-bold text-gray-900">{{ number_format($stats['expired']) }}</p>
                                <div class="mt-2 flex items-center text-sm">
                                    <span class="font-semibold {{ $growth['expired'] >= 0 ? 'text-red-600' : 'text-green-600' }}">
                                        {{ $growth['expired'] >= 0 ? '+' : '' }}{{ number_format($growth['expired'], 1) }}%
                            </span>
                                    <span class="ml-2 text-gray-500">from last month</span>
                                </div>
                            </div>
                            <div class="rounded-full bg-red-100 p-3">
                                <svg class="h-8 w-8 text-red-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                </svg>
                            </div>
                        </div>
                    </div>

                    <!-- Revenue -->
                    <div class="relative overflow-hidden rounded-xl bg-white p-6 shadow-sm border border-gray-200 hover:shadow-md transition-shadow">
                        <div class="flex items-center justify-between">
                            <div>
                                <p class="text-sm font-medium text-gray-600">Monthly Revenue</p>
                                <p class="mt-2 text-3xl font-bold text-gray-900">${{ number_format($stats['revenue'] / 1000, 1) }}K</p>
                                <div class="mt-2 flex items-center text-sm">
                                    <span class="font-semibold {{ $growth['revenue'] >= 0 ? 'text-green-600' : 'text-red-600' }}">
                                        {{ $growth['revenue'] >= 0 ? '+' : '' }}{{ number_format($growth['revenue'], 1) }}%
                                </span>
                                    <span class="ml-2 text-gray-500">from last month</span>
                                </div>
                            </div>
                            <div class="rounded-full bg-yellow-100 p-3">
                                <svg class="h-8 w-8 text-yellow-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                    </svg>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Charts Row -->
                <div class="grid grid-cols-1 gap-6 lg:grid-cols-3 mb-8">
                    <!-- License Activity Chart -->
                    <div class="lg:col-span-2 rounded-xl bg-white p-6 shadow-sm border border-gray-200">
                        <div class="mb-6 flex items-center justify-between">
                            <div>
                                <h3 class="text-lg font-bold text-gray-900">License Activity</h3>
                                <p class="text-sm text-gray-500">Daily license creation trend (Last 7 days)</p>
                            </div>
                        </div>
                        <div class="h-64 flex items-end justify-between gap-2">
                            @foreach($chartData as $data)
                            <div class="flex-1 flex flex-col items-center gap-2">
                                <div class="w-full bg-indigo-500 rounded-t hover:bg-indigo-600 transition-colors relative group" 
                                     style="height: {{ max($data['percentage'], 5) }}%">
                                    <div class="absolute -top-8 left-1/2 transform -translate-x-1/2 bg-gray-900 text-white text-xs px-2 py-1 rounded opacity-0 group-hover:opacity-100 transition-opacity whitespace-nowrap">
                                        {{ $data['count'] }} licenses
                                    </div>
                                </div>
                                <span class="text-xs text-gray-500 mt-1">{{ $data['date'] }}</span>
                            </div>
                            @endforeach
                        </div>
                    </div>

                    <!-- License Status Distribution -->
                    <div class="rounded-xl bg-white p-6 shadow-sm border border-gray-200">
                        <h3 class="text-lg font-bold text-gray-900 mb-6">Status Distribution</h3>
                        <div class="space-y-4">
                            <div>
                                <div class="flex items-center justify-between mb-2">
                                    <span class="text-sm font-medium text-gray-700">Active</span>
                                    <span class="text-sm font-semibold text-gray-900">{{ $statusDistribution['active'] }}%</span>
                                </div>
                                <div class="h-2 bg-gray-200 rounded-full overflow-hidden">
                                    <div class="h-full bg-green-500 transition-all" style="width: {{ $statusDistribution['active'] }}%"></div>
                                </div>
                            </div>
                            <div>
                                <div class="flex items-center justify-between mb-2">
                                    <span class="text-sm font-medium text-gray-700">Expired</span>
                                    <span class="text-sm font-semibold text-gray-900">{{ $statusDistribution['expired'] }}%</span>
                                </div>
                                <div class="h-2 bg-gray-200 rounded-full overflow-hidden">
                                    <div class="h-full bg-red-500 transition-all" style="width: {{ $statusDistribution['expired'] }}%"></div>
                                </div>
                            </div>
                            <div>
                                <div class="flex items-center justify-between mb-2">
                                    <span class="text-sm font-medium text-gray-700">Trial</span>
                                    <span class="text-sm font-semibold text-gray-900">{{ $statusDistribution['trial'] }}%</span>
                                </div>
                                <div class="h-2 bg-gray-200 rounded-full overflow-hidden">
                                    <div class="h-full bg-yellow-500 transition-all" style="width: {{ $statusDistribution['trial'] }}%"></div>
                                </div>
                            </div>
                            <div>
                                <div class="flex items-center justify-between mb-2">
                                    <span class="text-sm font-medium text-gray-700">Suspended</span>
                                    <span class="text-sm font-semibold text-gray-900">{{ $statusDistribution['suspended'] }}%</span>
                                </div>
                                <div class="h-2 bg-gray-200 rounded-full overflow-hidden">
                                    <div class="h-full bg-orange-500 transition-all" style="width: {{ $statusDistribution['suspended'] }}%"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Recent Licenses Table -->
                <div class="rounded-xl bg-white shadow-sm border border-gray-200 overflow-hidden">
                    <div class="border-b border-gray-200 bg-gray-50 px-6 py-4">
                        <div class="flex items-center justify-between">
                            <div>
                                <h3 class="text-lg font-bold text-gray-900">Recent Licenses</h3>
                                <p class="text-sm text-gray-500">Latest license activations and updates</p>
                            </div>
                            <a href="{{ route('licenses.create') }}" class="rounded-lg bg-indigo-600 px-4 py-2 text-sm font-semibold text-white shadow-sm hover:bg-indigo-700 transition-colors">
                                + New License
                            </a>
                        </div>
                    </div>
                    <div class="overflow-x-auto">
                        <table class="w-full">
                            <thead class="bg-gray-50 border-b border-gray-200">
                                <tr>
                                    <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">License Key</th>
                                    <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Customer</th>
                                    <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Product</th>
                                    <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Plan</th>
                                    <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Status</th>
                                    <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Expires</th>
                                    <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Actions</th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-gray-200 bg-white">
                                @forelse($recentLicenses as $license)
                                <tr class="hover:bg-gray-50 transition-colors">
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <span class="font-mono text-sm text-gray-900">{{ substr($license->license_key, 0, 4) }}-****-****-{{ substr($license->license_key, -4) }}</span>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <div class="flex items-center">
                                            <div class="h-8 w-8 rounded-full {{ ['bg-indigo-100', 'bg-purple-100', 'bg-green-100', 'bg-red-100', 'bg-yellow-100'][array_rand(['bg-indigo-100', 'bg-purple-100', 'bg-green-100', 'bg-red-100', 'bg-yellow-100'])] }} flex items-center justify-center {{ ['text-indigo-600', 'text-purple-600', 'text-green-600', 'text-red-600', 'text-yellow-600'][array_rand(['text-indigo-600', 'text-purple-600', 'text-green-600', 'text-red-600', 'text-yellow-600'])] }} font-semibold text-sm">
                                                {{ strtoupper(substr($license->customer_name, 0, 1)) }}{{ strtoupper(substr(explode(' ', $license->customer_name)[1] ?? 'X', 0, 1)) }}
                                            </div>
                                            <div class="ml-3">
                                                <p class="text-sm font-medium text-gray-900">{{ $license->customer_name }}</p>
                                                <p class="text-xs text-gray-500">{{ $license->customer_email }}</p>
                                            </div>
                </div>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-700">
                                        {{ $license->product_name }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <span class="inline-flex rounded-full px-2 py-1 text-xs font-semibold 
                                            {{ $license->plan_type === 'enterprise' ? 'bg-purple-100 text-purple-800' : '' }}
                                            {{ $license->plan_type === 'premium' ? 'bg-blue-100 text-blue-800' : '' }}
                                            {{ $license->plan_type === 'professional' ? 'bg-indigo-100 text-indigo-800' : '' }}
                                            {{ $license->plan_type === 'basic' ? 'bg-gray-100 text-gray-800' : '' }}
                                            {{ $license->plan_type === 'trial' ? 'bg-yellow-100 text-yellow-800' : '' }}">
                                            {{ ucfirst($license->plan_type) }}
                                        </span>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        @if($license->expired_at && $license->expired_at < now())
                                            <span class="inline-flex rounded-full bg-red-100 px-3 py-1 text-xs font-semibold text-red-800">
                                                Expired
                                            </span>
                                        @elseif($license->status === 'active')
                                            <span class="inline-flex rounded-full bg-green-100 px-3 py-1 text-xs font-semibold text-green-800">
                                                Active
                                            </span>
                                        @elseif($license->status === 'suspended')
                                            <span class="inline-flex rounded-full bg-orange-100 px-3 py-1 text-xs font-semibold text-orange-800">
                                                Suspended
                                            </span>
                                        @else
                                            <span class="inline-flex rounded-full bg-gray-100 px-3 py-1 text-xs font-semibold text-gray-800">
                                                Inactive
                                            </span>
                                        @endif
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-700">
                                        {{ $license->expired_at ? $license->expired_at->format('M d, Y') : 'N/A' }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm">
                                        <a href="{{ route('licenses.edit', $license) }}" class="text-indigo-600 hover:text-indigo-900 font-medium">Edit</a>
                                        <a href="{{ route('licenses.show', $license) }}" class="ml-3 text-gray-600 hover:text-gray-900 font-medium">View</a>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="7" class="px-6 py-12 text-center">
                                        <div class="flex flex-col items-center justify-center text-gray-500">
                                            <svg class="h-12 w-12 mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 13V6a2 2 0 00-2-2H6a2 2 0 00-2 2v7m16 0v5a2 2 0 01-2 2H6a2 2 0 01-2-2v-5m16 0h-2.586a1 1 0 00-.707.293l-2.414 2.414a1 1 0 01-.707.293h-3.172a1 1 0 01-.707-.293l-2.414-2.414A1 1 0 006.586 13H4" />
                    </svg>
                                            <p class="text-lg font-medium">No licenses found</p>
                                            <p class="text-sm">Get started by creating your first license</p>
                                        </div>
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    @if($recentLicenses->count() > 0)
                    <div class="border-t border-gray-200 bg-gray-50 px-6 py-4 flex items-center justify-between">
                        <p class="text-sm text-gray-700">
                            Showing <span class="font-semibold">{{ $recentLicenses->count() }}</span> of <span class="font-semibold">{{ $stats['total'] }}</span> licenses
                        </p>
                        <div class="flex gap-2">
                            <a href="{{ route('licenses.index') }}" class="px-3 py-1 rounded-lg border border-gray-300 text-sm font-medium text-gray-700 hover:bg-gray-100 transition-colors">View All</a>
                        </div>
                    </div>
                    @endif
                </div>
            </main>
        </div>
    </body>
</html>
