<?php

use App\Http\Controllers\LicenseController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

// Apply rate limiting to all API routes
Route::middleware(['throttle:api'])->group(function () {
    // License verification endpoint
    Route::get('/verify', [LicenseController::class, 'check']);

    // License activation endpoint
    Route::post('/activate', [LicenseController::class, 'activate']);
});

