

<?php $__env->startSection('title', 'Licenses Management'); ?>
<?php $__env->startSection('page-title', 'Licenses'); ?>
<?php $__env->startSection('page-subtitle', 'Manage all your license keys'); ?>

<?php $__env->startSection('header-actions'); ?>
<a href="<?php echo e(route('licenses.create')); ?>" class="rounded-lg bg-indigo-600 px-4 py-2 text-sm font-semibold text-white shadow-sm hover:bg-indigo-700 transition-colors flex items-center gap-2">
    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4" />
    </svg>
    New License
</a>
<a href="<?php echo e(route('licenses.export')); ?>" class="rounded-lg bg-green-600 px-4 py-2 text-sm font-semibold text-white shadow-sm hover:bg-green-700 transition-colors flex items-center gap-2">
    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-4l-4 4m0 0l-4-4m4 4V4" />
    </svg>
    Export CSV
</a>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<!-- Filters & Search -->
<div class="mb-6 rounded-xl bg-white p-6 shadow-sm border border-gray-200">
    <form method="GET" action="<?php echo e(route('licenses.index')); ?>" class="grid grid-cols-1 md:grid-cols-5 gap-4">
        <!-- Search -->
        <div class="md:col-span-2">
            <label class="block text-sm font-medium text-gray-700 mb-2">Search</label>
            <input type="text" name="search" value="<?php echo e(request('search')); ?>" placeholder="License key, customer, email, domain..." class="w-full rounded-lg border border-gray-300 px-4 py-2 text-sm focus:border-indigo-500 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
        </div>

        <!-- Status Filter -->
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-2">Status</label>
            <select name="status" class="w-full rounded-lg border border-gray-300 px-4 py-2 text-sm focus:border-indigo-500 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                <option value="">All Status</option>
                <option value="active" <?php echo e(request('status') === 'active' ? 'selected' : ''); ?>>Active</option>
                <option value="inactive" <?php echo e(request('status') === 'inactive' ? 'selected' : ''); ?>>Inactive</option>
                <option value="suspended" <?php echo e(request('status') === 'suspended' ? 'selected' : ''); ?>>Suspended</option>
            </select>
        </div>

        <!-- Plan Type Filter -->
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-2">Plan Type</label>
            <select name="plan_type" class="w-full rounded-lg border border-gray-300 px-4 py-2 text-sm focus:border-indigo-500 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                <option value="">All Plans</option>
                <option value="basic" <?php echo e(request('plan_type') === 'basic' ? 'selected' : ''); ?>>Basic</option>
                <option value="professional" <?php echo e(request('plan_type') === 'professional' ? 'selected' : ''); ?>>Professional</option>
                <option value="premium" <?php echo e(request('plan_type') === 'premium' ? 'selected' : ''); ?>>Premium</option>
                <option value="enterprise" <?php echo e(request('plan_type') === 'enterprise' ? 'selected' : ''); ?>>Enterprise</option>
                <option value="trial" <?php echo e(request('plan_type') === 'trial' ? 'selected' : ''); ?>>Trial</option>
            </select>
        </div>

        <!-- Expiry Filter -->
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-2">Expiry</label>
            <select name="expiry" class="w-full rounded-lg border border-gray-300 px-4 py-2 text-sm focus:border-indigo-500 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                <option value="">All</option>
                <option value="expired" <?php echo e(request('expiry') === 'expired' ? 'selected' : ''); ?>>Expired</option>
                <option value="expiring_soon" <?php echo e(request('expiry') === 'expiring_soon' ? 'selected' : ''); ?>>Expiring Soon (30 days)</option>
            </select>
        </div>

        <div class="md:col-span-5 flex gap-2">
            <button type="submit" class="rounded-lg bg-indigo-600 px-6 py-2 text-sm font-semibold text-white shadow-sm hover:bg-indigo-700 transition-colors">
                Apply Filters
            </button>
            <a href="<?php echo e(route('licenses.index')); ?>" class="rounded-lg bg-gray-100 px-6 py-2 text-sm font-semibold text-gray-700 hover:bg-gray-200 transition-colors">
                Clear
            </a>
        </div>
    </form>
</div>

<!-- Licenses Table -->
<div class="rounded-xl bg-white shadow-sm border border-gray-200 overflow-hidden">
    <div class="overflow-x-auto">
        <table class="w-full">
            <thead class="bg-gray-50 border-b border-gray-200">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">License Key</th>
                    <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Customer</th>
                    <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Product</th>
                    <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Plan</th>
                    <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Status</th>
                    <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Domain</th>
                    <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Expires</th>
                    <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Actions</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-200 bg-white">
                <?php $__empty_1 = true; $__currentLoopData = $licenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $license): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr class="hover:bg-gray-50 transition-colors">
                    <td class="px-6 py-4 whitespace-nowrap">
                        <span class="font-mono text-sm text-gray-900"><?php echo e($license->license_key); ?></span>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <div>
                            <p class="text-sm font-medium text-gray-900"><?php echo e($license->customer_name); ?></p>
                            <p class="text-xs text-gray-500"><?php echo e($license->customer_email); ?></p>
                        </div>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-700">
                        <?php echo e($license->product_name); ?>

                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <span class="inline-flex rounded-full px-2 py-1 text-xs font-semibold 
                            <?php echo e($license->plan_type === 'enterprise' ? 'bg-purple-100 text-purple-800' : ''); ?>

                            <?php echo e($license->plan_type === 'premium' ? 'bg-blue-100 text-blue-800' : ''); ?>

                            <?php echo e($license->plan_type === 'professional' ? 'bg-indigo-100 text-indigo-800' : ''); ?>

                            <?php echo e($license->plan_type === 'basic' ? 'bg-gray-100 text-gray-800' : ''); ?>

                            <?php echo e($license->plan_type === 'trial' ? 'bg-yellow-100 text-yellow-800' : ''); ?>">
                            <?php echo e(ucfirst($license->plan_type)); ?>

                        </span>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <?php if($license->expired_at && $license->expired_at < now()): ?>
                            <span class="inline-flex rounded-full bg-red-100 px-3 py-1 text-xs font-semibold text-red-800">
                                Expired
                            </span>
                        <?php elseif($license->status === 'active'): ?>
                            <span class="inline-flex rounded-full bg-green-100 px-3 py-1 text-xs font-semibold text-green-800">
                                Active
                            </span>
                        <?php elseif($license->status === 'suspended'): ?>
                            <span class="inline-flex rounded-full bg-orange-100 px-3 py-1 text-xs font-semibold text-orange-800">
                                Suspended
                            </span>
                        <?php else: ?>
                            <span class="inline-flex rounded-full bg-gray-100 px-3 py-1 text-xs font-semibold text-gray-800">
                                Inactive
                            </span>
                        <?php endif; ?>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-700">
                        <?php echo e($license->domain ?? '-'); ?>

                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-700">
                        <?php echo e($license->expired_at ? $license->expired_at->format('M d, Y') : 'N/A'); ?>

                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm">
                        <div class="flex items-center gap-2">
                            <a href="<?php echo e(route('licenses.show', $license)); ?>" class="text-indigo-600 hover:text-indigo-900 font-medium">View</a>
                            <a href="<?php echo e(route('licenses.edit', $license)); ?>" class="text-gray-600 hover:text-gray-900 font-medium">Edit</a>
                            <form method="POST" action="<?php echo e(route('licenses.destroy', $license)); ?>" class="inline" onsubmit="return confirm('Are you sure you want to delete this license?');">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="text-red-600 hover:text-red-900 font-medium">Delete</button>
                            </form>
                        </div>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="8" class="px-6 py-12 text-center">
                        <div class="flex flex-col items-center justify-center text-gray-500">
                            <svg class="h-12 w-12 mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 13V6a2 2 0 00-2-2H6a2 2 0 00-2 2v7m16 0v5a2 2 0 01-2 2H6a2 2 0 01-2-2v-5m16 0h-2.586a1 1 0 00-.707.293l-2.414 2.414a1 1 0 01-.707.293h-3.172a1 1 0 01-.707-.293l-2.414-2.414A1 1 0 006.586 13H4" />
                            </svg>
                            <p class="text-lg font-medium">No licenses found</p>
                            <p class="text-sm">Try adjusting your filters or create a new license</p>
                        </div>
                    </td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <?php if($licenses->count() > 0): ?>
    <div class="border-t border-gray-200 bg-gray-50 px-6 py-4">
        <?php echo e($licenses->links()); ?>

    </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\lisensiapi\resources\views/licenses/index.blade.php ENDPATH**/ ?>