

<?php $__env->startSection('title', 'Customers'); ?>
<?php $__env->startSection('page-title', 'Customers'); ?>
<?php $__env->startSection('page-subtitle', 'Manage customer accounts'); ?>

<?php $__env->startSection('content'); ?>
<!-- Search Bar -->
<div class="mb-6 rounded-xl bg-white p-6 shadow-sm border border-gray-200">
    <form method="GET" action="<?php echo e(route('customers.index')); ?>" class="flex gap-4">
        <div class="flex-1">
            <input type="text" name="search" value="<?php echo e(request('search')); ?>" placeholder="Search by name or email..." 
                class="w-full rounded-lg border border-gray-300 px-4 py-2 text-sm focus:border-indigo-500 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
        </div>
        <button type="submit" class="rounded-lg bg-indigo-600 px-6 py-2 text-sm font-semibold text-white shadow-sm hover:bg-indigo-700 transition-colors">
            Search
        </button>
        <?php if(request('search')): ?>
        <a href="<?php echo e(route('customers.index')); ?>" class="rounded-lg bg-gray-100 px-6 py-2 text-sm font-semibold text-gray-700 hover:bg-gray-200 transition-colors">
            Clear
        </a>
        <?php endif; ?>
    </form>
</div>

<!-- Stats Cards -->
<div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-6">
    <div class="rounded-xl bg-white p-6 shadow-sm border border-gray-200">
        <p class="text-sm font-medium text-gray-600">Total Customers</p>
        <p class="mt-2 text-3xl font-bold text-gray-900"><?php echo e($customers->total()); ?></p>
    </div>
    <div class="rounded-xl bg-white p-6 shadow-sm border border-gray-200">
        <p class="text-sm font-medium text-gray-600">Avg Licenses/Customer</p>
        <p class="mt-2 text-3xl font-bold text-gray-900"><?php echo e($customers->count() > 0 ? round($customers->sum('total_licenses') / $customers->count(), 1) : 0); ?></p>
    </div>
    <div class="rounded-xl bg-white p-6 shadow-sm border border-gray-200">
        <p class="text-sm font-medium text-gray-600">Total Active Licenses</p>
        <p class="mt-2 text-3xl font-bold text-gray-900"><?php echo e($customers->sum('active_licenses')); ?></p>
    </div>
    <div class="rounded-xl bg-white p-6 shadow-sm border border-gray-200">
        <p class="text-sm font-medium text-gray-600">Total Revenue</p>
        <p class="mt-2 text-3xl font-bold text-gray-900">$<?php echo e(number_format($customers->sum('active_licenses') * 50)); ?></p>
    </div>
</div>

<!-- Customers Table -->
<div class="rounded-xl bg-white shadow-sm border border-gray-200 overflow-hidden">
    <div class="overflow-x-auto">
        <table class="w-full">
            <thead class="bg-gray-50 border-b border-gray-200">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Customer</th>
                    <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Total Licenses</th>
                    <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Active Licenses</th>
                    <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Revenue</th>
                    <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Last License</th>
                    <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Actions</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-200 bg-white">
                <?php $__empty_1 = true; $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr class="hover:bg-gray-50 transition-colors">
                    <td class="px-6 py-4">
                        <div class="flex items-center">
                            <div class="h-10 w-10 rounded-full bg-indigo-100 flex items-center justify-center text-indigo-600 font-semibold">
                                <?php echo e(strtoupper(substr($customer->customer_name, 0, 1))); ?><?php echo e(strtoupper(substr(explode(' ', $customer->customer_name)[1] ?? 'X', 0, 1))); ?>

                            </div>
                            <div class="ml-3">
                                <p class="text-sm font-medium text-gray-900"><?php echo e($customer->customer_name); ?></p>
                                <p class="text-xs text-gray-500"><?php echo e($customer->customer_email); ?></p>
                            </div>
                        </div>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <span class="text-sm font-semibold text-gray-900"><?php echo e($customer->total_licenses); ?></span>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <span class="inline-flex rounded-full bg-green-100 px-3 py-1 text-xs font-semibold text-green-800">
                            <?php echo e($customer->active_licenses); ?>

                        </span>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">
                        $<?php echo e(number_format($customer->active_licenses * 50)); ?>

                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-700">
                        <?php echo e(\Carbon\Carbon::parse($customer->last_license_date)->format('M d, Y')); ?>

                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm">
                        <div class="flex items-center gap-2">
                            <a href="<?php echo e(route('customers.show', urlencode($customer->customer_email))); ?>" class="text-indigo-600 hover:text-indigo-900 font-medium">View</a>
                            <form method="POST" action="<?php echo e(route('customers.destroy', urlencode($customer->customer_email))); ?>" class="inline" onsubmit="return confirm('Delete this customer and all their licenses?');">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="text-red-600 hover:text-red-900 font-medium">Delete</button>
                            </form>
                        </div>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="6" class="px-6 py-12 text-center text-gray-500">
                        <p class="text-lg font-medium">No customers found</p>
                    </td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <?php if($customers->count() > 0): ?>
    <div class="border-t border-gray-200 bg-gray-50 px-6 py-4">
        <?php echo e($customers->links()); ?>

    </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\lisensiapi\resources\views/customers/index.blade.php ENDPATH**/ ?>