# Komponen yang Belum Dibuat

## 🔴 Prioritas Tinggi

### 1. Middleware
- [ ] `app/Http/Middleware/CheckRole.php` - Middleware untuk role-based access control
- [ ] `app/Http/Middleware/CheckHierarchy.php` - Middleware untuk cek hierarki Polda/Polres/Polsek

### 2. Seeders
- [ ] `database/seeders/PoldaSeeder.php` - Seeder untuk data Polda
- [ ] `database/seeders/PolresSeeder.php` - Seeder untuk data Polres
- [ ] `database/seeders/PolsekSeeder.php` - Seeder untuk data Polsek
- [ ] `database/seeders/UserSeeder.php` - Seeder untuk user admin dan sample users
- [ ] `database/seeders/CctvSeeder.php` - Seeder untuk sample CCTV
- [ ] `database/seeders/PanicButtonSeeder.php` - Seeder untuk sample panic buttons
- [ ] Update `DatabaseSeeder.php` untuk memanggil semua seeder

### 3. Migration Tambahan
- [ ] Migration untuk menambahkan `device_token` ke tabel users (untuk push notification)

### 4. Form Request Validation
- [ ] `app/Http/Requests/StoreComplaintRequest.php`
- [ ] `app/Http/Requests/UpdateComplaintRequest.php`
- [ ] `app/Http/Requests/StoreDispatchRequest.php`
- [ ] `app/Http/Requests/StoreFieldReportRequest.php`
- [ ] `app/Http/Requests/StoreCoordinationRequest.php`

### 5. Config Files
- [ ] Update `config/services.php` untuk voice logger, WhatsApp, SMS gateway

## 🟡 Prioritas Sedang

### 6. Jobs (Background Processing)
- [ ] `app/Jobs/SendNotificationJob.php` - Job untuk mengirim notifikasi
- [ ] `app/Jobs/ProcessAnalyticsJob.php` - Job untuk memproses analytics harian
- [ ] `app/Jobs/CaptureCctvSnapshotJob.php` - Job untuk capture CCTV snapshot
- [ ] `app/Jobs/DownloadRecordingJob.php` - Job untuk download recording dari voice logger

### 7. Events & Listeners
- [ ] `app/Events/ComplaintCreated.php` - Event ketika complaint dibuat
- [ ] `app/Events/DispatchCreated.php` - Event ketika dispatch dibuat
- [ ] `app/Events/PanicButtonActivated.php` - Event ketika panic button diaktifkan
- [ ] `app/Listeners/SendComplaintNotification.php` - Listener untuk kirim notifikasi
- [ ] `app/Listeners/AutoDispatchComplaint.php` - Listener untuk auto-dispatch
- [ ] `app/Listeners/CaptureCctvOnComplaint.php` - Listener untuk capture CCTV

### 8. API Resources
- [ ] `app/Http/Resources/ComplaintResource.php`
- [ ] `app/Http/Resources/DispatchResource.php`
- [ ] `app/Http/Resources/CctvResource.php`
- [ ] `app/Http/Resources/OfficerResource.php`

### 9. Policies (Authorization)
- [ ] `app/Policies/ComplaintPolicy.php`
- [ ] `app/Policies/DispatchPolicy.php`
- [ ] `app/Policies/CctvPolicy.php`
- [ ] `app/Policies/OfficerPolicy.php`

### 10. Webhook Controllers
- [ ] `app/Http/Controllers/WebhookController.php` - Untuk menerima webhook dari external services
- [ ] `app/Http/Controllers/Webhook/VoiceLoggerWebhookController.php`
- [ ] `app/Http/Controllers/Webhook/WhatsAppWebhookController.php`
- [ ] `app/Http/Controllers/Webhook/SmsWebhookController.php`

## 🟢 Prioritas Rendah

### 11. Commands (Artisan Commands)
- [ ] `app/Console/Commands/GenerateDailyAnalytics.php` - Command untuk generate analytics harian
- [ ] `app/Console/Commands/CleanupOldRecordings.php` - Command untuk cleanup recording lama
- [ ] `app/Console/Commands/SyncCctvStatus.php` - Command untuk sync status CCTV

### 12. Exceptions
- [ ] `app/Exceptions/LocationTrackingException.php`
- [ ] `app/Exceptions/DispatchException.php`
- [ ] `app/Exceptions/RecordingException.php`

### 13. Helpers
- [ ] `app/Helpers/NotificationHelper.php`
- [ ] `app/Helpers/GeolocationHelper.php`

### 14. Traits
- [ ] `app/Traits/HasLocation.php` - Trait untuk model yang punya lokasi
- [ ] `app/Traits/HasHierarchy.php` - Trait untuk model yang punya hierarki

### 15. Observers
- [ ] `app/Observers/ComplaintObserver.php` - Observer untuk Complaint model
- [ ] `app/Observers/DispatchObserver.php` - Observer untuk Dispatch model

## 📋 Summary

### Yang Sudah Ada ✅
- Models (18 models)
- Controllers (10 controllers)
- Services (6 services)
- Routes (web routes)
- Migrations (18 migrations)
- 1 View (dashboard)

### Yang Belum Dibuat ❌
- Middleware (2)
- Seeders (7)
- Form Requests (5)
- Jobs (4)
- Events & Listeners (6)
- API Resources (4)
- Policies (4)
- Webhook Controllers (4)
- Commands (3)
- Config updates (1)
- Migration tambahan (1)

**Total: ~41 komponen yang perlu dibuat**

