# Daftar Prioritas Komponen yang Perlu Dibuat

## 🔴 PRIORITAS SANGAT TINGGI (Harus Segera Dibuat)

### 1. Layout & Components untuk Views
- [ ] `resources/views/layouts/app.blade.php` - Master layout
- [ ] `resources/views/components/header.blade.php` - Header component
- [ ] `resources/views/components/sidebar.blade.php` - Sidebar navigation
- [ ] `resources/views/components/footer.blade.php` - Footer component

### 2. Views Utama (14+ views)
- [ ] `resources/views/complaints/index.blade.php`
- [ ] `resources/views/complaints/show.blade.php`
- [ ] `resources/views/complaints/create.blade.php`
- [ ] `resources/views/dispatches/index.blade.php`
- [ ] `resources/views/dispatches/show.blade.php`
- [ ] `resources/views/cctvs/index.blade.php`
- [ ] `resources/views/cctvs/show.blade.php`
- [ ] `resources/views/panic-buttons/index.blade.php`
- [ ] `resources/views/panic-buttons/show.blade.php`
- [ ] `resources/views/field-reports/index.blade.php`
- [ ] `resources/views/field-reports/show.blade.php`
- [ ] `resources/views/coordinations/index.blade.php`
- [ ] `resources/views/knowledge-center/index.blade.php`
- [ ] `resources/views/knowledge-center/show.blade.php`
- [ ] `resources/views/analytics/index.blade.php`
- [ ] `resources/views/officers/index.blade.php`

### 3. Authentication
- [ ] Install Laravel Breeze atau Sanctum
- [ ] `resources/views/auth/login.blade.php`
- [ ] `resources/views/auth/register.blade.php`
- [ ] Register auth routes di `routes/web.php`

### 4. API Routes untuk Mobile App
- [ ] `routes/api.php` - File API routes
- [ ] API authentication dengan Sanctum
- [ ] API endpoints untuk mobile app

### 5. Event Listeners
- [ ] `app/Listeners/SendComplaintNotification.php` - Listener untuk ComplaintCreated
- [ ] Register di `app/Providers/EventServiceProvider.php`

### 6. Config Services
- [ ] Update `config/services.php` untuk:
  - Voice Logger (Panasonic/Sony/IBM)
  - WhatsApp Gateway
  - SMS Gateway
  - FCM Push Notification

## 🟡 PRIORITAS TINGGI (Penting untuk Production)

### 7. Form Request Validation
- [ ] `app/Http/Requests/StoreComplaintRequest.php`
- [ ] `app/Http/Requests/UpdateComplaintRequest.php`
- [ ] `app/Http/Requests/StoreDispatchRequest.php`
- [ ] `app/Http/Requests/StoreFieldReportRequest.php`

### 8. API Resources
- [ ] `app/Http/Resources/ComplaintResource.php`
- [ ] `app/Http/Resources/DispatchResource.php`
- [ ] `app/Http/Resources/CctvResource.php`
- [ ] `app/Http/Resources/OfficerResource.php`

### 9. Seeders Tambahan
- [ ] `database/seeders/PolresSeeder.php`
- [ ] `database/seeders/PolsekSeeder.php`
- [ ] `database/seeders/CctvSeeder.php`
- [ ] `database/seeders/PanicButtonSeeder.php`
- [ ] `database/seeders/OfficerSeeder.php`

### 10. Jobs Tambahan
- [ ] `app/Jobs/ProcessAnalyticsJob.php`
- [ ] `app/Jobs/CaptureCctvSnapshotJob.php`
- [ ] `app/Jobs/DownloadRecordingJob.php`

### 11. Events Tambahan
- [ ] `app/Events/DispatchCreated.php`
- [ ] `app/Events/PanicButtonActivated.php`
- [ ] Listeners untuk events tersebut

## 🟢 PRIORITAS SEDANG (Nice to Have)

### 12. Policies
- [ ] `app/Policies/ComplaintPolicy.php`
- [ ] `app/Policies/DispatchPolicy.php`
- [ ] `app/Policies/CctvPolicy.php`

### 13. Webhook Controllers
- [ ] `app/Http/Controllers/WebhookController.php`
- [ ] `app/Http/Controllers/Webhook/VoiceLoggerWebhookController.php`
- [ ] `app/Http/Controllers/Webhook/WhatsAppWebhookController.php`

### 14. Commands
- [ ] `app/Console/Commands/GenerateDailyAnalytics.php`
- [ ] `app/Console/Commands/CleanupOldRecordings.php`

### 15. Middleware Tambahan
- [ ] `app/Http/Middleware/CheckHierarchy.php`

## 📋 Summary

### Yang Paling Penting (Harus Segera):
1. **Layout & Components** - 4 files
2. **Views** - 16+ files
3. **Authentication** - Install Breeze + views
4. **API Routes** - 1 file + endpoints
5. **Event Listeners** - 1+ listener
6. **Config** - Update services.php

**Total: ~25+ files yang harus segera dibuat**

### Progress Saat Ini:
- ✅ Backend Core: 100%
- ⚠️ Frontend: 7% (1 dari 20+ views)
- ❌ API: 0%
- ❌ Authentication: 0%
- ⚠️ Config: 0%

