# Sistem Call Center Polri Nasional

Sistem call center terintegrasi untuk Polda → Polres → Polsek dengan fitur lengkap untuk manajemen aduan, dispatching, CCTV, dan analytics.

## Fitur Utama

### 1. Dashboard Nasional
- Peta nasional real-time
- Status jumlah aduan masuk (per menit/jam/hari)
- Heatmap kriminal & insiden
- Status petugas, CCTV, dan perangkat lapangan
- Monitoring performa Polda/Polres/Polsek

### 2. Penerimaan Aduan + Auto Tracking
- Penerimaan aduan melalui:
  - Telepon 110 (PSTN, SIP Trunk, IP-PBX)
  - Mobile App
  - Panic Button
  - WA/SMS Darurat
- Auto-tracking menggunakan:
  - GPS (jika dari aplikasi)
  - Cell-ID / Triangulasi (kerjasama provider)
  - Kode area fallback

### 3. Klasifikasi Aduan (AI Assisted)
- Emergency (Polisi, Medis, Kebakaran, Bencana)
- Non-Emergency (disposisi ke Pemda, Dinsos, Dishub, dll.)
- AI/Rules Engine berdasarkan kata kunci dan riwayat

### 4. Recording
- Integrasi dengan Panasonic / Sony / IBM
- Penyimpanan terenkripsi
- Tautan rekaman otomatis ke data kasus

### 5. GIS Mapping + Auto Kamera
- Menandai titik lokasi di peta GIS
- Mengambil data wilayah (desa, kecamatan, polsek)
- Menarik daftar CCTV terdekat
- Snapshot realtime, live feed, playback

### 6. Auto Dispatching Engine
- Penentuan otomatis Polsek yang bertanggung jawab
- Unit yang harus dikirim (samapta, reskrim, lantas, medis, damkar, SAR)
- Notifikasi multi-channel (Mobile App, WhatsApp, SMS, Radio)
- Eskalasi otomatis

### 7. Koordinasi Internal & Eksternal
- Channel komunikasi internal (Operator ↔ Polsek, Polda ↔ Polres, dll.)
- Channel eksternal (Damkar, RS, BPBD, Basarnas, Dishub, Pemda)

### 8. CCTV Network se-NKRI
- Pooling seluruh kamera ke gateway nasional
- Load balancer untuk live stream
- Klasifikasi berdasarkan Polda/Polres/Polsek
- Snapshot otomatis saat kejadian

### 9. Panic Button Nasional
- Dipasang di Bank, Gedung Pemerintahan, Mall, Mobile App
- Alert otomatis dengan lokasi
- Auto-kamera wilayah terdekat aktif
- Dispatch otomatis

### 10. Pelaporan Petugas Lapangan
- Status tracking (diterima → menuju lokasi → tindakan → selesai)
- Upload foto/video dari TKP
- Tanda tangan digital
- Auto-sync ke dashboard nasional

### 11. Manajemen Data Berjenjang
- Akses berdasarkan struktur Polri (Polda → Polres → Polsek)
- Manajemen data: Aduan, CCTV, Unit patroli, Petugas, Panic button, Statistik

### 12. Knowledge Center
- Panduan keselamatan
- Edukasi digital safety
- Tata cara menghubungi layanan darurat
- Modul pelatihan operator

### 13. Notifikasi & Automation
- Notifikasi aduan baru
- Status penanganan
- Eskalasi antar satwil
- Broadcast peringatan darurat

### 14. Analitik & Heatmap Kriminal
- Response time Polda/Polres/Polsek
- Heatmap kriminal berdasarkan lokasi/tipe/waktu
- Prediksi area rawan
- Statistik harian, mingguan, bulanan

## Instalasi

### Requirements
- PHP >= 8.2
- MySQL >= 8.0
- Composer
- Node.js & NPM

### Setup

1. Clone repository
```bash
git clone <repository-url>
cd callcenter
```

2. Install dependencies
```bash
composer install
npm install
```

3. Setup environment
```bash
cp .env.example .env
php artisan key:generate
```

4. Konfigurasi database di `.env`:
```env
DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=callcenter
DB_USERNAME=root
DB_PASSWORD=
```

5. Jalankan migrations
```bash
php artisan migrate
```

6. (Optional) Seed data
```bash
php artisan db:seed
```

7. Build assets
```bash
npm run build
```

8. Jalankan server
```bash
php artisan serve
```

## Struktur Database

### Tabel Utama
- `users` - Pengguna sistem (Admin, Polda, Polres, Polsek, Operator, Petugas)
- `poldas` - Data Polda
- `polres` - Data Polres
- `polsek` - Data Polsek
- `complaints` - Aduan masuk
- `complaint_recordings` - Rekaman aduan
- `locations` - Data lokasi GPS/Cell-ID
- `cctvs` - Data CCTV
- `panic_buttons` - Data panic button
- `dispatches` - Data dispatch
- `dispatch_units` - Unit yang di-dispatch
- `officers` - Data petugas
- `notifications` - Notifikasi
- `knowledge_center` - Artikel knowledge center
- `analytics` - Data analytics
- `coordinations` - Koordinasi internal/eksternal
- `cctv_snapshots` - Snapshot CCTV
- `field_reports` - Laporan petugas lapangan
- `panic_button_activations` - Aktivasi panic button

## API Endpoints

### Dashboard
- `GET /api/dashboard` - Dashboard nasional
- `GET /api/dashboard/stats` - Statistik real-time

### Complaints
- `POST /api/complaints` - Buat aduan baru
- `GET /api/complaints` - Daftar aduan
- `GET /api/complaints/{id}` - Detail aduan
- `PUT /api/complaints/{id}` - Update aduan
- `POST /api/complaints/{id}/classify` - Klasifikasi aduan

### Dispatch
- `POST /api/dispatches` - Buat dispatch
- `GET /api/dispatches` - Daftar dispatch
- `POST /api/dispatches/{id}/accept` - Terima dispatch
- `POST /api/dispatches/{id}/complete` - Selesaikan dispatch

### CCTV
- `GET /api/cctvs` - Daftar CCTV
- `GET /api/cctvs/nearby` - CCTV terdekat
- `GET /api/cctvs/{id}/stream` - Live stream
- `POST /api/cctvs/{id}/snapshot` - Ambil snapshot

### Panic Button
- `POST /api/panic-buttons/{id}/activate` - Aktivasi panic button
- `GET /api/panic-buttons` - Daftar panic button

## Services

### LocationTrackingService
Service untuk tracking lokasi menggunakan GPS, Cell-ID, atau triangulasi.

### ComplaintClassificationService
Service untuk klasifikasi aduan menggunakan AI/Rules Engine.

### DispatchService
Service untuk auto-dispatching dan eskalasi.

### NotificationService
Service untuk mengirim notifikasi multi-channel.

### CctvService
Service untuk manajemen CCTV dan snapshot.

## License

MIT License
