# Panduan Setup Sistem Call Center Polri

## Langkah-langkah Instalasi

### 1. Setup Database MySQL

Buat database baru:
```sql
CREATE DATABASE callcenter CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
```

### 2. Konfigurasi .env

Edit file `.env` dan sesuaikan konfigurasi database:
```env
DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=callcenter
DB_USERNAME=root
DB_PASSWORD=your_password
```

### 3. Jalankan Migrations

```bash
php artisan migrate
```

### 4. Buat User Admin

Jalankan tinker untuk membuat user admin:
```bash
php artisan tinker
```

Kemudian jalankan:
```php
$user = \App\Models\User::create([
    'name' => 'Admin',
    'email' => 'admin@polri.go.id',
    'password' => bcrypt('password'),
    'role' => 'admin',
]);
```

### 5. Setup Authentication

Jika belum ada, install Laravel Breeze atau Sanctum:
```bash
composer require laravel/breeze --dev
php artisan breeze:install
npm install && npm run build
```

### 6. Install Dependencies Tambahan (Opsional)

Untuk fitur tambahan, install:
- FFmpeg (untuk CCTV snapshot): `sudo apt-get install ffmpeg` (Linux) atau download dari https://ffmpeg.org
- Redis (untuk caching): `composer require predis/predis`

### 7. Setup Storage Link

```bash
php artisan storage:link
```

### 8. Jalankan Server

```bash
php artisan serve
```

Akses aplikasi di: http://localhost:8000

## Konfigurasi Tambahan

### Integrasi WhatsApp Gateway

Edit `.env`:
```env
WHATSAPP_API_URL=https://api.whatsapp.com
WHATSAPP_API_KEY=your_api_key
```

### Integrasi SMS Gateway

Edit `.env`:
```env
SMS_API_URL=https://api.sms-gateway.com
SMS_API_KEY=your_api_key
```

### Integrasi CCTV Recording

Edit `.env`:
```env
CCTV_RECORDING_ENABLED=true
CCTV_STORAGE_PATH=/path/to/recordings
```

### Integrasi Voice Logger (Panasonic/Sony/IBM)

Edit `.env`:
```env
VOICE_LOGGER_TYPE=panasonic
VOICE_LOGGER_API_URL=http://logger-ip:port
VOICE_LOGGER_API_KEY=your_api_key
```

## Struktur Data Awal

### Seeding Data Polda/Polres/Polsek

Buat seeder untuk data awal:
```bash
php artisan make:seeder PoldaPolresPolsekSeeder
```

## Testing

Jalankan tests:
```bash
php artisan test
```

## Production Deployment

1. Set `APP_ENV=production` di `.env`
2. Set `APP_DEBUG=false` di `.env`
3. Generate optimized autoloader: `composer install --optimize-autoloader --no-dev`
4. Cache config: `php artisan config:cache`
5. Cache routes: `php artisan route:cache`
6. Cache views: `php artisan view:cache`

## Troubleshooting

### Error: SQLSTATE[HY000] [2002] Connection refused
- Pastikan MySQL service berjalan
- Periksa konfigurasi database di `.env`

### Error: Class not found
- Jalankan `composer dump-autoload`
- Pastikan semua dependencies terinstall

### Error: Storage link tidak berfungsi
- Pastikan folder `storage/app/public` ada
- Jalankan `php artisan storage:link` lagi

## Support

Untuk bantuan lebih lanjut, hubungi tim development.

