<?php

namespace App\Events;

use App\Models\Dispatch;
use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PresenceChannel;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class DispatchCreated
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public function __construct(
        public Dispatch $dispatch
    ) {}

    public function broadcastOn(): array
    {
        return [
            new PrivateChannel('dispatches'),
        ];
    }
}
