<?php

namespace App\Events;

use App\Models\PanicButtonActivation;
use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PresenceChannel;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class PanicButtonActivated
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public function __construct(
        public PanicButtonActivation $activation
    ) {}

    public function broadcastOn(): array
    {
        return [
            new PrivateChannel('panic-buttons'),
        ];
    }
}
