<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\CallRecord;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Schema;

class CallRecordController extends Controller
{
    /**
     * Display a listing of call records
     */
    public function index(Request $request)
    {
        if (!Schema::hasTable('call_records')) {
            $callRecords = collect([]);
            return view('call-records.index', compact('callRecords'));
        }

        $query = CallRecord::with(['location', 'complaint'])
            ->orderBy('started_at', 'desc');

        // Apply filters
        if ($request->has('status')) {
            $query->where('status', $request->status);
        }

        if ($request->has('caller_id')) {
            $query->where('caller_id', 'like', '%' . $request->caller_id . '%');
        }

        $callRecords = $query->paginate(20);

        return view('call-records.index', compact('callRecords'));
    }

    /**
     * Display the specified call record
     */
    public function show(CallRecord $callRecord)
    {
        $callRecord->load(['location', 'complaint']);
        
        return view('call-records.show', compact('callRecord'));
    }
}

