<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreComplaintRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'source' => 'required|in:phone,mobile_app,panic_button,whatsapp,sms',
            'caller_phone' => 'nullable|string|max:20',
            'caller_name' => 'nullable|string|max:255',
            'description' => 'required|string|min:10',
            'latitude' => 'nullable|numeric|between:-90,90',
            'longitude' => 'nullable|numeric|between:-180,180',
            'cell_id' => 'nullable|string|max:50',
            'phone_number' => 'nullable|string|max:20',
        ];
    }

    public function messages(): array
    {
        return [
            'description.required' => 'Deskripsi aduan wajib diisi',
            'description.min' => 'Deskripsi minimal 10 karakter',
            'source.required' => 'Sumber aduan wajib dipilih',
        ];
    }
}
